/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.util.EncodingUtils;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class OAuth20TokenAuthorizationResponseBuilder
implements OAuth20AuthorizationResponseBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenAuthorizationResponseBuilder.class);
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;

    public OAuth20TokenAuthorizationResponseBuilder(OAuth20TokenGenerator accessTokenGenerator, ExpirationPolicy accessTokenExpirationPolicy) {
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
    }

    @Override
    public View build(J2EContext context, String clientId, AccessTokenRequestDataHolder holder) {
        try {
            String redirectUri = context.getRequestParameter("redirect_uri");
            LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)clientId, (Object)redirectUri);
            Pair<AccessToken, RefreshToken> accessToken = this.accessTokenGenerator.generate(holder);
            LOGGER.debug("Generated OAuth access token: [{}]", accessToken.getKey());
            return this.buildCallbackUrlResponseType(holder, redirectUri, (AccessToken)accessToken.getKey(), new ArrayList<NameValuePair>(), (RefreshToken)accessToken.getValue(), context);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected View buildCallbackUrlResponseType(AccessTokenRequestDataHolder holder, String redirectUri, AccessToken accessToken, List<NameValuePair> params, RefreshToken refreshToken, J2EContext context) throws Exception {
        String state = holder.getAuthentication().getAttributes().get("state").toString();
        String nonce = holder.getAuthentication().getAttributes().get("nonce").toString();
        URIBuilder builder = new URIBuilder(redirectUri);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("access_token").append('=').append(accessToken.getId()).append('&').append("token_type").append('=').append("bearer").append('&').append("expires_in").append('=').append(this.accessTokenExpirationPolicy.getTimeToLive());
        if (refreshToken != null) {
            stringBuilder.append('&').append("refresh_token").append('=').append(refreshToken.getId());
        }
        params.forEach(p -> stringBuilder.append('&').append(p.getName()).append('=').append(p.getValue()));
        if (StringUtils.isNotBlank((CharSequence)state)) {
            stringBuilder.append('&').append("state").append('=').append(EncodingUtils.urlEncode((String)state));
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            stringBuilder.append('&').append("nonce").append('=').append(EncodingUtils.urlEncode((String)nonce));
        }
        builder.setFragment(stringBuilder.toString());
        String url = builder.toString();
        LOGGER.debug("Redirecting to URL [{}]", (Object)url);
        return new RedirectView(url);
    }

    @Override
    public boolean supports(J2EContext context) {
        String responseType = context.getRequestParameter("response_type");
        return StringUtils.equalsIgnoreCase((CharSequence)responseType, (CharSequence)OAuth20ResponseTypes.TOKEN.getType());
    }
}

