/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRequestDataHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenRequestDataHolder.class);
    private final Service service;
    private final Authentication authentication;
    private final OAuthToken token;
    private final boolean generateRefreshToken;
    private final OAuthRegisteredService registeredService;
    private final TicketGrantingTicket ticketGrantingTicket;
    private final OAuth20GrantTypes grantType;
    private final Set<String> scopes;

    public AccessTokenRequestDataHolder(OAuthToken token, OAuthRegisteredService registeredService, OAuth20GrantTypes grantType, boolean isAllowedToGenerateRefreshToken, Set<String> scopes) {
        this(token.getService(), token.getAuthentication(), token, registeredService, grantType, isAllowedToGenerateRefreshToken, scopes);
    }

    public AccessTokenRequestDataHolder(Service service, Authentication authentication, OAuthToken token, OAuthRegisteredService registeredService, OAuth20GrantTypes grantType, boolean isAllowedToGenerateRefreshToken, Set<String> scopes) {
        this(service, authentication, registeredService, token, null, grantType, isAllowedToGenerateRefreshToken, scopes);
    }

    public AccessTokenRequestDataHolder(Service service, Authentication authentication, OAuthRegisteredService registeredService, TicketGrantingTicket ticketGrantingTicket, OAuth20GrantTypes grantType, Set<String> scopes) {
        this(service, authentication, registeredService, null, ticketGrantingTicket, grantType, true, scopes);
    }

    private AccessTokenRequestDataHolder(Service service, Authentication authentication, OAuthRegisteredService registeredService, OAuthToken token, TicketGrantingTicket ticketGrantingTicket, OAuth20GrantTypes grantType, boolean isAllowedToGenerateRefreshToken, Set<String> scopes) {
        this.service = service;
        this.authentication = authentication;
        this.registeredService = registeredService;
        this.ticketGrantingTicket = token != null ? token.getGrantingTicket() : ticketGrantingTicket;
        this.token = token;
        this.generateRefreshToken = isAllowedToGenerateRefreshToken ? registeredService != null && registeredService.isGenerateRefreshToken().booleanValue() : false;
        this.grantType = grantType;
        this.scopes = new LinkedHashSet<String>(scopes);
    }

    public OAuth20GrantTypes getGrantType() {
        return this.grantType;
    }

    public Service getService() {
        return this.service;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public OAuthToken getToken() {
        return this.token;
    }

    public boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    public OAuthRegisteredService getRegisteredService() {
        return this.registeredService;
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("service", (Object)this.service).append("authentication", (Object)this.authentication).append("token", (Object)this.token).append("generateRefreshToken", this.generateRefreshToken).append("registeredService", (Object)this.registeredService).append("ticketGrantingTicket", (Object)this.ticketGrantingTicket).append("grantType", (Object)this.grantType).append("scopes", this.scopes).toString();
    }
}

