/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20AccessTokenEndpointController
extends BaseOAuth20Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenEndpointController.class);
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;
    private final Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    public OAuth20AccessTokenEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20TokenGenerator accessTokenGenerator, AccessTokenResponseGenerator accessTokenResponseGenerator, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, ExpirationPolicy accessTokenExpirationPolicy, Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors) {
        super(servicesManager, ticketRegistry, validator, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
    }

    @PostMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AccessTokenRequestDataHolder responseHolder;
            response.setContentType("text/plain");
            if (!this.verifyAccessTokenRequest(request, response)) {
                LOGGER.error("Access token request verification failed");
                OAuth20Utils.writeTextError(response, "invalid_request");
                return;
            }
            try {
                responseHolder = this.examineAndExtractAccessTokenGrantRequest(request, response);
                LOGGER.debug("Creating access token for [{}]", (Object)responseHolder);
            }
            catch (Exception e) {
                LOGGER.error("Could not identify and extract access token request", (Throwable)e);
                OAuth20Utils.writeTextError(response, "invalid_grant");
                return;
            }
            J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
            Pair<AccessToken, RefreshToken> accessToken = this.accessTokenGenerator.generate(responseHolder);
            LOGGER.debug("Access token generated is: [{}]. Refresh token generated is [{}]", accessToken.getKey(), accessToken.getValue());
            this.generateAccessTokenResponse(request, response, responseHolder, context, (AccessToken)accessToken.getKey(), (RefreshToken)accessToken.getValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @GetMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public void handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.handleRequest(request, response);
    }

    private void generateAccessTokenResponse(HttpServletRequest request, HttpServletResponse response, AccessTokenRequestDataHolder responseHolder, J2EContext context, AccessToken accessToken, RefreshToken refreshToken) {
        LOGGER.debug("Generating access token response for [{}]", (Object)accessToken);
        OAuth20ResponseTypes type = OAuth20Utils.getResponseType(context);
        LOGGER.debug("Located response type as [{}]", (Object)type);
        this.accessTokenResponseGenerator.generate(request, response, responseHolder.getRegisteredService(), responseHolder.getService(), accessToken, refreshToken, this.accessTokenExpirationPolicy.getTimeToLive(), type);
    }

    private AccessTokenRequestDataHolder examineAndExtractAccessTokenGrantRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.accessTokenGrantRequestExtractors.stream().filter(ext -> ext.supports(request)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Request is not supported")).extract(request, response);
    }

    private boolean verifyAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String grantType = request.getParameter("grant_type");
        if (!OAuth20AccessTokenEndpointController.isGrantTypeSupported(grantType, OAuth20GrantTypes.values())) {
            LOGGER.warn("Grant type is not supported: [{}]", (Object)grantType);
            return false;
        }
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            LOGGER.warn("Could not locate authenticated profile for this request");
            return false;
        }
        UserProfile uProfile = (UserProfile)profile.get();
        if (uProfile == null) {
            LOGGER.warn("Could not locate authenticated profile for this request as null");
            return false;
        }
        if (OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.AUTHORIZATION_CODE)) {
            return this.verifyAccessForGrantAuthorizationCode(request, grantType, uProfile);
        }
        if (OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.REFRESH_TOKEN)) {
            return this.verifyAccessForGrantRefreshToken(request, uProfile);
        }
        if (OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.PASSWORD)) {
            return this.verifyAccessForGrantPassword(request, grantType, uProfile);
        }
        if (OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.CLIENT_CREDENTIALS)) {
            return this.verifyAccessForGrantClientCredentials(request, grantType, uProfile);
        }
        return false;
    }

    private boolean verifyAccessForGrantClientCredentials(HttpServletRequest request, String grantType, UserProfile uProfile) {
        String clientId = request.getParameter("client_id");
        LOGGER.debug("Received grant type [{}] with client id [{}]", (Object)grantType, (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        return this.validator.checkParameterExist(request, "client_id") && this.validator.checkServiceValid((RegisteredService)registeredService);
    }

    private boolean verifyAccessForGrantPassword(HttpServletRequest request, String grantType, UserProfile uProfile) {
        String clientId = request.getParameter("client_id");
        LOGGER.debug("Received grant type [{}] with client id [{}]", (Object)grantType, (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        return this.validator.checkParameterExist(request, "client_id") && this.validator.checkServiceValid((RegisteredService)registeredService);
    }

    private boolean verifyAccessForGrantRefreshToken(HttpServletRequest request, UserProfile uProfile) {
        if (!(this.validator.checkParameterExist(request, "refresh_token") && this.validator.checkParameterExist(request, "client_id") && this.validator.checkParameterExist(request, "client_secret"))) {
            return false;
        }
        String token = request.getParameter("refresh_token");
        Ticket refreshToken = this.ticketRegistry.getTicket(token);
        if (refreshToken == null) {
            LOGGER.warn("Provided refresh token [{}] cannot be found in the registry", (Object)token);
            return false;
        }
        if (!RefreshToken.class.isAssignableFrom(refreshToken.getClass())) {
            LOGGER.warn("Provided refresh token [{}] is found in the registry but its type is not classified as a refresh token", (Object)token);
            return false;
        }
        if (refreshToken.isExpired()) {
            LOGGER.warn("Provided refresh token [{}] has expired and is no longer valid.", (Object)token);
            return false;
        }
        return true;
    }

    private boolean verifyAccessForGrantAuthorizationCode(HttpServletRequest request, String grantType, UserProfile uProfile) {
        String clientId = uProfile.getId();
        String redirectUri = request.getParameter("redirect_uri");
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        LOGGER.debug("Received grant type [{}] with client id [{}] and redirect URI [{}]", new Object[]{grantType, clientId, redirectUri});
        return this.validator.checkParameterExist(request, "redirect_uri") && this.validator.checkParameterExist(request, "code") && this.validator.checkCallbackValid((RegisteredService)registeredService, redirectUri);
    }

    private static boolean isGrantTypeSupported(String type, OAuth20GrantTypes ... expectedTypes) {
        LOGGER.debug("Grant type: [{}]", (Object)type);
        for (OAuth20GrantTypes expectedType : expectedTypes) {
            if (!OAuth20Utils.isGrantType(type, expectedType)) continue;
            return true;
        }
        LOGGER.error("Unsupported grant type: [{}]", (Object)type);
        return false;
    }
}

