/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20RequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeResponseTypeRequestValidator
implements OAuth20RequestValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeResponseTypeRequestValidator.class);
    private final ServicesManager servicesManager;
    private final OAuth20Validator validator;

    public OAuth20AuthorizationCodeResponseTypeRequestValidator(ServicesManager servicesManager, OAuth20Validator validator) {
        this.servicesManager = servicesManager;
        this.validator = validator;
    }

    @Override
    public boolean validate(J2EContext context) {
        boolean checkParameterExist;
        HttpServletRequest request = context.getRequest();
        boolean bl = checkParameterExist = this.validator.checkParameterExist(request, "client_id") && this.validator.checkParameterExist(request, "redirect_uri") && this.validator.checkParameterExist(request, "response_type");
        if (!checkParameterExist) {
            LOGGER.warn("Missing required parameters (client id, redirect uri, etc) for response type [{}].", (Object)this.getResponseType());
            return false;
        }
        String responseType = request.getParameter("response_type");
        if (!OAuth20Validator.checkResponseTypes(responseType, OAuth20ResponseTypes.values())) {
            LOGGER.warn("Response type [{}] is not supported.", (Object)responseType);
            return false;
        }
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        if (!this.validator.checkServiceValid((RegisteredService)registeredService)) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", (Object)registeredService);
            return false;
        }
        String redirectUri = request.getParameter("redirect_uri");
        if (!this.validator.checkCallbackValid((RegisteredService)registeredService, redirectUri)) {
            LOGGER.warn("Callback URL [{}] is not authorized for registered service [{}].", (Object)redirectUri, (Object)registeredService);
            return false;
        }
        return OAuth20Utils.isAuthorizedResponseTypeForService(context, registeredService);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("response_type");
        return OAuth20Utils.isResponseType(grantType, this.getResponseType());
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.CODE;
    }
}

