/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegexRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.authenticator.OAuthClientAuthenticator;
import org.apereo.cas.support.oauth.authenticator.OAuthUserAuthenticator;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20AuthorizationCodeResponseTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20ClientCredentialsGrantTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20IdTokenResponseTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20PasswordGrantTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20RefreshTokenGrantTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20RequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20TokenResponseTypeRequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.OAuth20CasCallbackUrlResolver;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20CallbackAuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileControllerController;
import org.apereo.cas.support.oauth.web.response.OAuth20CasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20DefaultTokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenClientCredentialsGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenPasswordGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRefreshTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.views.OAuth20DefaultUserProfileViewRenderer;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.DefaultAccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuthAccessTokenExpirationPolicy;
import org.apereo.cas.ticket.code.DefaultOAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.refreshtoken.DefaultRefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.OAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.http.UrlResolver;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.direct.DirectFormClient;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="oauthConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuthConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry ticketRegistry;
    @Autowired
    @Qualifier(value="ticketGrantingTicketCookieGenerator")
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;

    @ConditionalOnMissingBean(name={"accessTokenResponseGenerator"})
    @Bean
    public AccessTokenResponseGenerator accessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @ConditionalOnMissingBean(name={"oauthCasClientRedirectActionBuilder"})
    @Bean
    public OAuth20CasClientRedirectActionBuilder oauthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @RefreshScope
    @Bean
    public UrlResolver casCallbackUrlResolver() {
        return new OAuth20CasCallbackUrlResolver(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()));
    }

    @RefreshScope
    @Bean
    public Config oauthSecConfig() {
        CasConfiguration cfg = new CasConfiguration(this.casProperties.getServer().getLoginUrl());
        CasClient oauthCasClient = new CasClient(cfg);
        oauthCasClient.setRedirectActionBuilder(webContext -> this.oauthCasClientRedirectActionBuilder().build(oauthCasClient, webContext));
        oauthCasClient.setName("CasOAuthClient");
        oauthCasClient.setUrlResolver(this.casCallbackUrlResolver());
        Authenticator<UsernamePasswordCredentials> authenticator = this.oAuthClientAuthenticator();
        DirectBasicAuthClient basicAuthClient = new DirectBasicAuthClient(authenticator);
        basicAuthClient.setName("clientBasicAuth");
        DirectFormClient directFormClient = new DirectFormClient(authenticator);
        directFormClient.setName("clientForm");
        directFormClient.setUsernameParameter("client_id");
        directFormClient.setPasswordParameter("client_secret");
        DirectFormClient userFormClient = new DirectFormClient(this.oAuthUserAuthenticator());
        userFormClient.setName("userForm");
        return new Config(OAuth20Utils.casOAuthCallbackUrl(this.casProperties.getServer().getPrefix()), new Client[]{oauthCasClient, basicAuthClient, directFormClient, userFormClient});
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    @RefreshScope
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        return new SecurityInterceptor(this.oauthSecConfig(), "CasOAuthClient");
    }

    @ConditionalOnMissingBean(name={"consentApprovalViewResolver"})
    @Bean
    @RefreshScope
    public ConsentApprovalViewResolver consentApprovalViewResolver() {
        return new OAuth20ConsentApprovalViewResolver(this.casProperties);
    }

    @ConditionalOnMissingBean(name={"callbackAuthorizeViewResolver"})
    @Bean
    @RefreshScope
    public OAuth20CallbackAuthorizeViewResolver callbackAuthorizeViewResolver() {
        return new OAuth20CallbackAuthorizeViewResolver(){};
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    @RefreshScope
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        String clients = Stream.of("clientBasicAuth", "clientForm", "userForm").collect(Collectors.joining(","));
        return new SecurityInterceptor(this.oauthSecConfig(), clients);
    }

    @ConditionalOnMissingBean(name={"oauthInterceptor"})
    @Bean
    @RefreshScope
    public HandlerInterceptorAdapter oauthInterceptor() {
        String throttler = this.casProperties.getAuthn().getOauth().getThrottler();
        OAuth20HandlerInterceptorAdapter oAuth20HandlerInterceptorAdapter = new OAuth20HandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor(), (HandlerInterceptorAdapter)this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors());
        if ("neverThrottle".equalsIgnoreCase(throttler)) {
            LOGGER.debug("Authentication throttling is disabled for OAuth");
            return oAuth20HandlerInterceptorAdapter;
        }
        return this.getHandlerInterceptorForThrottling(oAuth20HandlerInterceptorAdapter);
    }

    private HandlerInterceptorAdapter getHandlerInterceptorForThrottling(final OAuth20HandlerInterceptorAdapter oAuth20HandlerInterceptorAdapter) {
        String throttler = this.casProperties.getAuthn().getOauth().getThrottler();
        LOGGER.debug("Locating authentication throttler instance [{}] for OAuth", (Object)throttler);
        final HandlerInterceptor throttledInterceptor = (HandlerInterceptor)this.applicationContext.getBean(throttler, HandlerInterceptor.class);
        String throttledUrl = "/oauth2.0".concat("/").concat("accessToken|token");
        final Pattern pattern = RegexUtils.createPattern((String)throttledUrl);
        LOGGER.debug("Authentication throttler instance for OAuth shall intercept the URL pattern [{}]", (Object)pattern.pattern());
        HandlerInterceptorAdapter throttledInterceptorAdapter = new HandlerInterceptorAdapter(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                if (RegexUtils.matches((Pattern)pattern, (String)request.getServletPath()) && !throttledInterceptor.preHandle(request, response, handler)) {
                    LOGGER.trace("OAuth authentication throttler prevented the request at [{}]", (Object)request.getServletPath());
                    return false;
                }
                return oAuth20HandlerInterceptorAdapter.preHandle(request, response, handler);
            }

            public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
                if (RegexUtils.matches((Pattern)pattern, (String)request.getServletPath())) {
                    LOGGER.trace("OAuth authentication throttler post-processing the request at [{}]", (Object)request.getServletPath());
                    throttledInterceptor.postHandle(request, response, handler, modelAndView);
                }
            }
        };
        return throttledInterceptorAdapter;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.oauthInterceptor()).addPathPatterns(new String[]{"/oauth2.0".concat("/").concat("*")});
    }

    @Bean
    @RefreshScope
    public OAuth20CasClientRedirectActionBuilder defaultOAuthCasClientRedirectActionBuilder() {
        return new OAuth20DefaultCasClientRedirectActionBuilder();
    }

    @ConditionalOnMissingBean(name={"oAuthClientAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator<UsernamePasswordCredentials> oAuthClientAuthenticator() {
        return new OAuthClientAuthenticator(this.oAuthValidator(), this.servicesManager);
    }

    @ConditionalOnMissingBean(name={"oAuthUserAuthenticator"})
    @Bean
    @RefreshScope
    public Authenticator<UsernamePasswordCredentials> oAuthUserAuthenticator() {
        return new OAuthUserAuthenticator(this.authenticationSystemSupport, this.servicesManager, this.webApplicationServiceFactory);
    }

    @ConditionalOnMissingBean(name={"oAuthValidator"})
    @Bean
    @RefreshScope
    public OAuth20Validator oAuthValidator() {
        return new OAuth20Validator((ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory);
    }

    @ConditionalOnMissingBean(name={"oauthAccessTokenResponseGenerator"})
    @Bean
    @RefreshScope
    public AccessTokenResponseGenerator oauthAccessTokenResponseGenerator() {
        return new OAuth20AccessTokenResponseGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultAccessTokenFactory"})
    public AccessTokenFactory defaultAccessTokenFactory() {
        return new DefaultAccessTokenFactory(this.accessTokenIdGenerator(), this.accessTokenExpirationPolicy());
    }

    @Bean
    @ConditionalOnMissingBean(name={"accessTokenExpirationPolicy"})
    public ExpirationPolicy accessTokenExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuthAccessTokenExpirationPolicy(oauth.getAccessToken().getMaxTimeToLiveInSeconds(), oauth.getAccessToken().getTimeToKillInSeconds());
    }

    private ExpirationPolicy oAuthCodeExpirationPolicy() {
        OAuthProperties oauth = this.casProperties.getAuthn().getOauth();
        return new OAuthCodeExpirationPolicy(oauth.getCode().getNumberOfUses(), oauth.getCode().getTimeToKillInSeconds());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"oAuthCodeIdGenerator"})
    public UniqueTicketIdGenerator oAuthCodeIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"refreshTokenIdGenerator"})
    public UniqueTicketIdGenerator refreshTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultOAuthCodeFactory"})
    public OAuthCodeFactory defaultOAuthCodeFactory() {
        return new DefaultOAuthCodeFactory(this.oAuthCodeIdGenerator(), this.oAuthCodeExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"profileScopeToAttributesFilter"})
    @Bean
    public OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter() {
        return new DefaultOAuth20ProfileScopeToAttributesFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"callbackAuthorizeController"})
    @RefreshScope
    public OAuth20CallbackAuthorizeEndpointController callbackAuthorizeController() {
        return new OAuth20CallbackAuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.oauthSecConfig(), this.callbackAuthorizeViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator);
    }

    @ConditionalOnMissingBean(name={"oauthTokenGenerator"})
    @Bean
    @RefreshScope
    public OAuth20TokenGenerator oauthTokenGenerator() {
        return new OAuth20DefaultTokenGenerator(this.defaultAccessTokenFactory(), this.ticketRegistry, this.defaultRefreshTokenFactory());
    }

    @Bean
    public Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors() {
        AccessTokenAuthorizationCodeGrantRequestExtractor authzCodeExt = new AccessTokenAuthorizationCodeGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth());
        AccessTokenRefreshTokenGrantRequestExtractor refreshTokenExt = new AccessTokenRefreshTokenGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.centralAuthenticationService, this.casProperties.getAuthn().getOauth());
        AccessTokenPasswordGrantRequestExtractor pswExt = new AccessTokenPasswordGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.oauthCasAuthenticationBuilder(), this.centralAuthenticationService, this.casProperties.getAuthn().getOauth());
        AccessTokenClientCredentialsGrantRequestExtractor credsExt = new AccessTokenClientCredentialsGrantRequestExtractor(this.servicesManager, this.ticketRegistry, this.oauthCasAuthenticationBuilder(), this.centralAuthenticationService, this.casProperties.getAuthn().getOauth());
        return CollectionUtils.wrapList((Object[])new BaseAccessTokenGrantRequestExtractor[]{authzCodeExt, refreshTokenExt, pswExt, credsExt});
    }

    @ConditionalOnMissingBean(name={"accessTokenController"})
    @Bean
    @RefreshScope
    public OAuth20AccessTokenEndpointController accessTokenController() {
        return new OAuth20AccessTokenEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.oauthTokenGenerator(), this.accessTokenResponseGenerator(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator, this.accessTokenExpirationPolicy(), this.accessTokenGrantRequestExtractors());
    }

    @ConditionalOnMissingBean(name={"oauthUserProfileViewRenderer"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileViewRenderer oauthUserProfileViewRenderer() {
        return new OAuth20DefaultUserProfileViewRenderer(this.casProperties.getAuthn().getOauth());
    }

    @ConditionalOnMissingBean(name={"profileController"})
    @Bean
    @RefreshScope
    public OAuth20UserProfileControllerController profileController() {
        return new OAuth20UserProfileControllerController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator, this.oauthUserProfileViewRenderer());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationResponseBuilders"})
    @Bean
    @RefreshScope
    public Set<OAuth20AuthorizationResponseBuilder> oauthAuthorizationResponseBuilders() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20AuthorizationResponseBuilder.class, false, true);
        return new HashSet<OAuth20AuthorizationResponseBuilder>(builders.values());
    }

    @ConditionalOnMissingBean(name={"oauthRequestValidators"})
    @Bean
    @RefreshScope
    public Set<OAuth20RequestValidator> oauthRequestValidators() {
        Map builders = this.applicationContext.getBeansOfType(OAuth20RequestValidator.class, false, true);
        return new HashSet<OAuth20RequestValidator>(builders.values());
    }

    @ConditionalOnMissingBean(name={"oauthClientCredentialsGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthClientCredentialsGrantTypeRequestValidator() {
        return new OAuth20ClientCredentialsGrantTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthAuthorizationCodeResponseTypeRequestValidator() {
        return new OAuth20AuthorizationCodeResponseTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthTokenResponseTypeRequestValidator() {
        return new OAuth20TokenResponseTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthIdTokenResponseTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthIdTokenResponseTypeRequestValidator() {
        return new OAuth20IdTokenResponseTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthPasswordGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthPasswordGrantTypeRequestValidator() {
        return new OAuth20PasswordGrantTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthRefreshTokenGrantTypeRequestValidator"})
    @Bean
    @RefreshScope
    public OAuth20RequestValidator oauthRefreshTokenGrantTypeRequestValidator() {
        return new OAuth20RefreshTokenGrantTypeRequestValidator(this.servicesManager, this.oAuthValidator());
    }

    @ConditionalOnMissingBean(name={"oauthResourceOwnerCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthResourceOwnerCredentialsResponseBuilder() {
        return new OAuth20ResourceOwnerCredentialsResponseBuilder(this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthClientCredentialsResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthClientCredentialsResponseBuilder() {
        return new OAuth20ClientCredentialsResponseBuilder(this.accessTokenResponseGenerator(), this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthTokenResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthTokenResponseBuilder() {
        return new OAuth20TokenAuthorizationResponseBuilder(this.oauthTokenGenerator(), this.accessTokenExpirationPolicy());
    }

    @ConditionalOnMissingBean(name={"oauthAuthorizationCodeResponseBuilder"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizationResponseBuilder oauthAuthorizationCodeResponseBuilder() {
        return new OAuth20AuthorizationCodeAuthorizationResponseBuilder(this.ticketRegistry, this.defaultOAuthCodeFactory());
    }

    @ConditionalOnMissingBean(name={"authorizeController"})
    @Bean
    @RefreshScope
    public OAuth20AuthorizeEndpointController authorizeController() {
        return new OAuth20AuthorizeEndpointController(this.servicesManager, this.ticketRegistry, this.oAuthValidator(), this.defaultAccessTokenFactory(), this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.defaultOAuthCodeFactory(), this.consentApprovalViewResolver(), this.profileScopeToAttributesFilter(), this.casProperties, this.ticketGrantingTicketCookieGenerator, this.oauthCasAuthenticationBuilder(), this.oauthAuthorizationResponseBuilders(), this.oauthRequestValidators());
    }

    @ConditionalOnMissingBean(name={"oauthPrincipalFactory"})
    @Bean
    @RefreshScope
    public PrincipalFactory oauthPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"defaultRefreshTokenFactory"})
    public RefreshTokenFactory defaultRefreshTokenFactory() {
        return new DefaultRefreshTokenFactory(this.refreshTokenIdGenerator(), this.refreshTokenExpirationPolicy());
    }

    private ExpirationPolicy refreshTokenExpirationPolicy() {
        return new OAuthRefreshTokenExpirationPolicy(this.casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds());
    }

    @ConditionalOnMissingBean(name={"oauthCasAuthenticationBuilder"})
    @Bean
    @RefreshScope
    public OAuth20CasAuthenticationBuilder oauthCasAuthenticationBuilder() {
        return new OAuth20CasAuthenticationBuilder(this.oauthPrincipalFactory(), (ServiceFactory<WebApplicationService>)this.webApplicationServiceFactory, this.profileScopeToAttributesFilter(), this.casProperties);
    }

    @ConditionalOnMissingBean(name={"accessTokenIdGenerator"})
    @Bean
    @RefreshScope
    public UniqueTicketIdGenerator accessTokenIdGenerator() {
        return new DefaultUniqueTicketIdGenerator();
    }

    @PostConstruct
    public void initializeServletApplicationContext() {
        String oAuthCallbackUrl = this.casProperties.getServer().getPrefix() + "/oauth2.0" + '/' + "callbackAuthorize.*";
        Service callbackService = this.webApplicationServiceFactory.createService(oAuthCallbackUrl);
        RegisteredService svc = this.servicesManager.findServiceBy(callbackService);
        if (svc == null || !svc.getServiceId().equals(oAuthCallbackUrl)) {
            RegexRegisteredService service = new RegexRegisteredService();
            service.setId(Math.abs(RandomUtils.getInstanceNative().nextLong()));
            service.setEvaluationOrder(0);
            service.setName(service.getClass().getSimpleName());
            service.setDescription("OAuth Authentication Callback Request URL");
            service.setServiceId(oAuthCallbackUrl);
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
            this.servicesManager.save((RegisteredService)service);
            this.servicesManager.load();
        }
    }
}

