/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.mongo.MongoDbAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;

public class MongoDbAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbAuthenticationHandler.class);
    private final MongoOperations mongoTemplate;
    private final MongoDbAuthenticationProperties properties;

    public MongoDbAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, MongoDbAuthenticationProperties properties, MongoOperations mongoTemplate) {
        super(name, servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.mongoTemplate = mongoTemplate;
        this.properties = properties;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws Throwable {
        MongoCollection collection = this.mongoTemplate.getCollection(this.properties.getCollection());
        try (MongoCursor it = collection.find(Filters.eq((String)this.properties.getUsernameAttribute(), (Object)transformedCredential.getUsername())).iterator();){
            if (it.hasNext()) {
                Document result = (Document)it.next();
                if (!result.containsKey((Object)this.properties.getPasswordAttribute())) {
                    throw new FailedLoginException("No password attribute found for " + transformedCredential.getId());
                }
                Object entryPassword = result.get((Object)this.properties.getPasswordAttribute());
                if (!this.getPasswordEncoder().matches((CharSequence)originalPassword, entryPassword.toString())) {
                    LOGGER.warn("Account password on record for [{}] does not match the given/encoded password", (Object)transformedCredential.getId());
                    throw new FailedLoginException();
                }
                HashMap attributes = result.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(this.properties.getPasswordAttribute()) && !((String)entry.getKey()).equals(this.properties.getUsernameAttribute())).collect(Collectors.toMap(Map.Entry::getKey, entry -> (List)CollectionUtils.toCollection(entry.getValue(), ArrayList.class), (__, b) -> b, () -> new HashMap()));
                Principal principal = this.principalFactory.createPrincipal(transformedCredential.getId(), (Map)attributes);
                AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult = this.createHandlerResult((Credential)transformedCredential, principal, new ArrayList());
                return authenticationHandlerExecutionResult;
            }
            throw new AccountNotFoundException("Unable to locate user account");
        }
    }
}

