/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.mongo.MongoDbAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDbAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler
implements AutoCloseable,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbAuthenticationHandler.class);
    private final MongoTemplate mongoTemplate;
    private final MongoDbAuthenticationProperties properties;

    public MongoDbAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, MongoDbAuthenticationProperties properties, MongoTemplate mongoTemplate) {
        super(name, servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.mongoTemplate = mongoTemplate;
        this.properties = properties;
    }

    public void destroy() {
        this.close();
    }

    @Override
    public void close() {
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws GeneralSecurityException {
        MongoCollection collection = this.mongoTemplate.getCollection(this.properties.getCollection());
        MongoCursor it = collection.find(Filters.eq((String)this.properties.getUsernameAttribute(), (Object)transformedCredential.getUsername())).iterator();
        if (it.hasNext()) {
            Document result = (Document)it.next();
            if (!result.containsKey((Object)this.properties.getUsernameAttribute())) {
                throw new FailedLoginException("No user attribute found for " + transformedCredential.getId());
            }
            if (!result.containsKey((Object)this.properties.getPasswordAttribute())) {
                throw new FailedLoginException("No password attribute found for " + transformedCredential.getId());
            }
            Object entryPassword = result.get((Object)this.properties.getPasswordAttribute());
            if (!this.getPasswordEncoder().matches((CharSequence)originalPassword, entryPassword.toString())) {
                LOGGER.warn("Account password on record for [{}] does not match the given/encoded password", (Object)transformedCredential.getId());
                throw new FailedLoginException();
            }
            HashMap attributes = new HashMap();
            result.entrySet().stream().filter(s -> !((String)s.getKey()).equals(this.properties.getPasswordAttribute()) && !((String)s.getKey()).equals(this.properties.getUsernameAttribute())).forEach(entry -> attributes.put((String)entry.getKey(), (List)CollectionUtils.toCollection(entry.getValue(), ArrayList.class)));
            Principal principal = this.principalFactory.createPrincipal(transformedCredential.getId(), attributes);
            return this.createHandlerResult((Credential)transformedCredential, principal, new ArrayList(0));
        }
        throw new FailedLoginException("Unable to locate user account");
    }
}

