/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.config;

import javax.net.ssl.SSLContext;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MongoDbAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.MongoDbAuthenticationProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="casMongoAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasMongoAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="sslContext")
    private ObjectProvider<SSLContext> sslContext;

    @ConditionalOnMissingBean(name={"mongoPrincipalFactory"})
    @Bean
    public PrincipalFactory mongoPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"mongoAuthenticationHandler"})
    public AuthenticationHandler mongoAuthenticationHandler() {
        MongoDbAuthenticationProperties mongo = this.casProperties.getAuthn().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory((SSLContext)this.sslContext.getObject());
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        MongoDbAuthenticationHandler handler = new MongoDbAuthenticationHandler(mongo.getName(), (ServicesManager)this.servicesManager.getObject(), this.mongoPrincipalFactory(), mongo, mongoTemplate);
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)mongo.getPasswordEncoder(), (ApplicationContext)this.applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)mongo.getPrincipalTransformation()));
        return handler;
    }

    @ConditionalOnMissingBean(name={"mongoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer mongoAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.mongoAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
    }
}

