/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MongoAuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.mongo.MongoAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.credentials.password.SpringSecurityPasswordEncoder;
import org.pac4j.mongo.profile.service.MongoProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casMongoAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasMongoAuthenticationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasMongoAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;

    @ConditionalOnMissingBean(name={"mongoPrincipalFactory"})
    @Bean
    public PrincipalFactory mongoPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler mongoAuthenticationHandler() {
        MongoAuthenticationProperties mongo = this.casProperties.getAuthn().getMongo();
        MongoAuthenticationHandler handler = new MongoAuthenticationHandler(mongo.getName(), this.servicesManager, this.mongoPrincipalFactory());
        handler.setAuthenticator((Authenticator)this.mongoAuthenticatorProfileService());
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)mongo.getPrincipalTransformation()));
        return handler;
    }

    @ConditionalOnMissingBean(name={"mongoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer mongoAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.mongoAuthenticationHandler(), this.personDirectoryPrincipalResolver);
    }

    @ConditionalOnMissingBean(name={"mongoAuthenticatorProfileService"})
    @Bean
    public MongoProfileService mongoAuthenticatorProfileService() {
        MongoAuthenticationProperties mongo = this.casProperties.getAuthn().getMongo();
        MongoClientURI uri = new MongoClientURI(mongo.getMongoHostUri());
        MongoClient client = new MongoClient(uri);
        LOGGER.info("Connected to MongoDb instance @ [{}] using database [{}]", (Object)uri.getHosts(), (Object)uri.getDatabase());
        SpringSecurityPasswordEncoder encoder = new SpringSecurityPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)mongo.getPasswordEncoder()));
        MongoProfileService auth = new MongoProfileService(client, mongo.getAttributes());
        auth.setUsersCollection(mongo.getCollectionName());
        auth.setUsersDatabase(uri.getDatabase());
        auth.setUsernameAttribute(mongo.getUsernameAttribute());
        auth.setPasswordAttribute(mongo.getPasswordAttribute());
        auth.setPasswordEncoder((PasswordEncoder)encoder);
        return auth;
    }
}

