/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.couchbase.BaseCouchbaseProperties;
import org.apereo.cas.configuration.model.support.couchbase.authentication.CouchbasePrincipalAttributesProperties;
import org.apereo.cas.couchbase.core.CouchbaseClientFactory;
import org.apereo.cas.couchbase.core.DefaultCouchbaseClientFactory;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.support.CouchbasePersonAttributeDao;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="couchbase")
@AutoConfiguration
@Deprecated(since="7.0.0")
public class CouchbasePersonDirectoryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.couchbase.username-attribute");

    @ConditionalOnMissingBean(name={"couchbasePersonAttributeDao"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public IPersonAttributeDao couchbasePersonAttributeDao(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (IPersonAttributeDao)BeanSupplier.of(IPersonAttributeDao.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            CouchbasePrincipalAttributesProperties couchbase = casProperties.getAuthn().getAttributeRepository().getCouchbase();
            CouchbasePersonAttributeDao cb = new CouchbasePersonAttributeDao(couchbase, (CouchbaseClientFactory)new DefaultCouchbaseClientFactory((BaseCouchbaseProperties)couchbase));
            cb.setOrder(couchbase.getOrder());
            FunctionUtils.doIfNotNull((Object)couchbase.getId(), xva$0 -> cb.setId(new String[]{xva$0}));
            return cb;
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"couchbaseAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer couchbaseAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="couchbasePersonAttributeDao") IPersonAttributeDao couchbasePersonAttributeDao) throws Exception {
        return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAttributeRepository(couchbasePersonAttributeDao)).otherwiseProxy().get();
    }
}

