/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CouchbaseAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.couchbase.BaseCouchbaseProperties;
import org.apereo.cas.configuration.model.support.couchbase.authentication.CouchbaseAuthenticationProperties;
import org.apereo.cas.couchbase.core.CouchbaseClientFactory;
import org.apereo.cas.couchbase.core.DefaultCouchbaseClientFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="couchbase")
@AutoConfiguration
@Deprecated(since="7.0.0")
public class CouchbaseAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseAuthenticationConfiguration.class);

    @ConditionalOnMissingBean(name={"couchbasePrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory couchbasePrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"authenticationCouchbaseClientFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public CouchbaseClientFactory authenticationCouchbaseClientFactory(CasConfigurationProperties casProperties) {
        CouchbaseAuthenticationProperties couchbase = casProperties.getAuthn().getCouchbase();
        return new DefaultCouchbaseClientFactory((BaseCouchbaseProperties)couchbase);
    }

    @ConditionalOnMissingBean(name={"couchbaseAuthenticationHandler"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationHandler couchbaseAuthenticationHandler(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="couchbasePrincipalFactory") PrincipalFactory couchbasePrincipalFactory, @Qualifier(value="authenticationCouchbaseClientFactory") CouchbaseClientFactory authenticationCouchbaseClientFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        CouchbaseAuthenticationProperties couchbase = casProperties.getAuthn().getCouchbase();
        CouchbaseAuthenticationHandler handler = new CouchbaseAuthenticationHandler(servicesManager, couchbasePrincipalFactory, authenticationCouchbaseClientFactory, couchbase);
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)couchbase.getPrincipalTransformation()));
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)couchbase.getPasswordEncoder(), (ApplicationContext)applicationContext));
        return handler;
    }

    @ConditionalOnMissingBean(name={"couchbaseAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer couchbaseAuthenticationEventExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="couchbaseAuthenticationHandler") AuthenticationHandler couchbaseAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> {
            CouchbaseAuthenticationProperties couchbase = casProperties.getAuthn().getCouchbase();
            if (StringUtils.isNotBlank((CharSequence)couchbase.getPasswordAttribute()) && StringUtils.isNotBlank((CharSequence)couchbase.getUsernameAttribute())) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(couchbaseAuthenticationHandler, defaultPrincipalResolver);
            } else {
                LOGGER.debug("No couchbase username/password is defined, so couchbase authentication will not be registered in the execution plan");
            }
        };
    }
}

