/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryResult;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.couchbase.authentication.CouchbaseAuthenticationProperties;
import org.apereo.cas.couchbase.core.CouchbaseClientFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="7.0.0")
public class CouchbaseAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseAuthenticationHandler.class);
    private final CouchbaseAuthenticationProperties couchbaseProperties;
    private final CouchbaseClientFactory couchbase;

    public CouchbaseAuthenticationHandler(ServicesManager servicesManager, PrincipalFactory principalFactory, CouchbaseClientFactory couchbase, CouchbaseAuthenticationProperties couchbaseProperties) {
        super(couchbaseProperties.getName(), servicesManager, principalFactory, Integer.valueOf(couchbaseProperties.getOrder()));
        this.couchbase = couchbase;
        this.couchbaseProperties = couchbaseProperties;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws GeneralSecurityException {
        String query = String.format("%s = '%s'", this.couchbaseProperties.getUsernameAttribute(), transformedCredential.getUsername());
        QueryResult result = this.couchbase.select(query);
        List results = result.rowsAsObject();
        if (results.isEmpty()) {
            LOGGER.error("Couchbase query did not return any results/rows.");
            throw new AccountNotFoundException("Could not locate account for user " + transformedCredential.getUsername());
        }
        if (results.size() > 1) {
            throw new FailedLoginException("More then one row found for user " + transformedCredential.getId());
        }
        JsonObject row = ((JsonObject)results.get(0)).getObject(this.couchbase.getBucket());
        if (!row.containsKey(this.couchbaseProperties.getPasswordAttribute())) {
            throw new FailedLoginException("No password attribute found for " + transformedCredential.getId());
        }
        String entryPassword = row.getString(this.couchbaseProperties.getPasswordAttribute());
        if (!this.getPasswordEncoder().matches((CharSequence)originalPassword, entryPassword)) {
            LOGGER.warn("Account password on record for [{}] does not match the given/encoded password", (Object)transformedCredential.getId());
            throw new FailedLoginException();
        }
        Map attributes = CouchbaseClientFactory.collectAttributesFromEntity((JsonObject)row, s -> !s.equals(this.couchbaseProperties.getPasswordAttribute()) && !s.equals(this.couchbaseProperties.getUsernameAttribute()));
        Principal principal = this.principalFactory.createPrincipal(transformedCredential.getId(), attributes);
        return this.createHandlerResult((Credential)transformedCredential, principal, new ArrayList(0));
    }
}

