/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import java.net.InetAddress;
import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.aws.BaseAmazonWebServicesProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;

public class AmazonClientConfigurationBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonClientConfigurationBuilder.class);

    public static AwsSyncClientBuilder prepareSyncClientBuilder(AwsSyncClientBuilder builder, AwsCredentialsProvider credentialsProvider, BaseAmazonWebServicesProperties props) {
        SdkSyncClientBuilder clientBuilder;
        ProxyConfiguration.Builder proxyConfig = ProxyConfiguration.builder();
        if (StringUtils.isNotBlank((CharSequence)props.getProxyHost())) {
            proxyConfig.endpoint((URI)FunctionUtils.doUnchecked(() -> new URI(props.getProxyHost()))).password(props.getProxyPassword()).username(props.getProxyUsername());
        }
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
        httpClientBuilder.useIdleConnectionReaper(Boolean.valueOf(props.isUseReaper())).socketTimeout(Beans.newDuration((String)props.getSocketTimeout())).maxConnections(Integer.valueOf(props.getMaxConnections())).connectionTimeout(Beans.newDuration((String)props.getConnectionTimeout())).connectionAcquisitionTimeout(Beans.newDuration((String)props.getClientExecutionTimeout()));
        if (StringUtils.isNotBlank((CharSequence)props.getLocalAddress())) {
            LOGGER.trace("Creating DynamoDb client local address [{}]", (Object)props.getLocalAddress());
            httpClientBuilder.localAddress((InetAddress)FunctionUtils.doUnchecked(() -> InetAddress.getByName(props.getLocalAddress())));
        }
        if ((clientBuilder = builder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)) instanceof AwsClientBuilder) {
            AwsClientBuilder awsClientBuilder = (AwsClientBuilder)clientBuilder;
            ClientOverrideConfiguration overrideConfig = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryMode.valueOf((String)props.getRetryMode())).build();
            awsClientBuilder.overrideConfiguration(overrideConfig);
            awsClientBuilder.credentialsProvider(credentialsProvider);
            String region = props.getRegion();
            awsClientBuilder.region(StringUtils.isBlank((CharSequence)region) ? Region.AWS_GLOBAL : Region.of((String)region));
            String endpoint = props.getEndpoint();
            if (StringUtils.isNotBlank((CharSequence)endpoint)) {
                awsClientBuilder.endpointOverride((URI)FunctionUtils.doUnchecked(() -> new URI(endpoint)));
            }
        }
        return builder;
    }
}

