/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.net.InetAddress;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.aws.ChainingAWSCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class AmazonEnvironmentAwareClientBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonEnvironmentAwareClientBuilder.class);
    private final String propertyPrefix;
    private final Environment environment;

    public String getSetting(String key) {
        return this.environment.getProperty(this.propertyPrefix + '.' + key);
    }

    public String getSetting(String key, String defaultValue) {
        String result = this.environment.getProperty(this.propertyPrefix + '.' + key);
        return (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)defaultValue);
    }

    public <T> T getSetting(String key, Class<T> targetType) {
        return (T)this.environment.getProperty(this.propertyPrefix + '.' + key, targetType);
    }

    public <T> T build(AwsClientBuilder builder, Class<T> clientType) {
        String endpoint;
        String finalRegion;
        String regionOverride;
        ClientConfiguration cfg = new ClientConfiguration();
        try {
            String localAddress = this.getSetting("localAddress");
            if (StringUtils.isNotBlank((CharSequence)localAddress)) {
                cfg.setLocalAddress(InetAddress.getByName(localAddress));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        builder.withClientConfiguration(cfg);
        String key = this.getSetting("credentialAccessKey");
        String secret = this.getSetting("credentialSecretKey");
        AWSCredentialsProvider credentials = ChainingAWSCredentialsProvider.getInstance(key, secret);
        builder.withCredentials(credentials);
        String region = this.getSetting("region");
        Region currentRegion = Regions.getCurrentRegion();
        if (currentRegion != null && StringUtils.isBlank((CharSequence)region)) {
            region = currentRegion.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)(regionOverride = this.getSetting("regionOverride")))) {
            regionOverride = currentRegion.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)(finalRegion = (String)StringUtils.defaultIfBlank((CharSequence)regionOverride, (CharSequence)region)))) {
            builder.withRegion(finalRegion);
        }
        if (StringUtils.isNotBlank((CharSequence)(endpoint = this.getSetting("endpoint"))) && StringUtils.isNotBlank((CharSequence)finalRegion)) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, finalRegion));
        }
        Object result = builder.build();
        return clientType.cast(result);
    }

    @Generated
    public AmazonEnvironmentAwareClientBuilder(String propertyPrefix, Environment environment) {
        this.propertyPrefix = propertyPrefix;
        this.environment = environment;
    }
}

