/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.web.flow;

import com.authy.api.Error;
import com.authy.api.Hash;
import com.authy.api.User;
import lombok.Generated;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthyAuthenticationRegistrationWebflowAction
extends AbstractAction {
    private final AuthyClientInstance instance;

    protected Event doExecute(RequestContext context) {
        Principal principal = WebUtils.getAuthentication((RequestContext)context).getPrincipal();
        User user = this.instance.getOrCreateUser(principal);
        if (!user.isOk()) {
            throw new IllegalArgumentException(AuthyClientInstance.getErrorMessage((Error)user.getError()));
        }
        Hash h = this.submitAuthyRegistrationRequest(user);
        if (!h.isOk() || !h.isSuccess()) {
            throw new IllegalArgumentException(AuthyClientInstance.getErrorMessage((Error)h.getError()).concat(h.getMessage()));
        }
        return this.success();
    }

    private Hash submitAuthyRegistrationRequest(User user) {
        return this.instance.getAuthyUsers().requestSms(user.getId());
    }

    @Generated
    public AuthyAuthenticationRegistrationWebflowAction(AuthyClientInstance instance) {
        this.instance = instance;
    }
}

