/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.AuthyMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="authyAuthenticationMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AuthyAuthenticationMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"authyBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator authyBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getAuthy().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyPrincipalMultifactorAuthenticationProviderBypass());
        }
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyRegisteredServiceMultifactorAuthenticationProviderBypass());
        bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator());
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypassEvaluator(this.authyRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"authyRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator authyRestMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new RestMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }

    @ConditionalOnMissingBean(name={"authyGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator authyGroovyMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }

    @ConditionalOnMissingBean(name={"authyHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator authyHttpRequestMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }

    @ConditionalOnMissingBean(name={"authyRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypassEvaluator authyRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(authy.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"authyCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator authyCredentialMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"authyRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator authyRegisteredServiceMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(authy.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"authyPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator authyPrincipalMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"authyAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator authyAuthenticationMultifactorAuthenticationProviderBypass() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        MultifactorAuthenticationProviderBypassProperties props = authy.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, authy.getId());
    }
}

