/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowAction;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorWebflowConfigurer;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="authyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AuthyConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private ObjectProvider<FlowDefinitionRegistry> loginFlowDefinitionRegistry;
    @Autowired
    private ObjectProvider<FlowBuilderServices> flowBuilderServices;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CasCookieBuilder> warnCookieGenerator;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;

    @Bean
    public FlowDefinitionRegistry authyAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, (FlowBuilderServices)this.flowBuilderServices.getObject());
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-authy/*-webflow.xml");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver authyAuthenticationWebflowEventResolver() {
        CasWebflowEventResolutionConfigurationContext context = CasWebflowEventResolutionConfigurationContext.builder().authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getObject()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getObject()).servicesManager((ServicesManager)this.servicesManager.getObject()).ticketRegistrySupport((TicketRegistrySupport)this.ticketRegistrySupport.getObject()).warnCookieGenerator((CasCookieBuilder)this.warnCookieGenerator.getObject()).authenticationRequestServiceSelectionStrategies((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).casProperties(this.casProperties).ticketRegistry((TicketRegistry)this.ticketRegistry.getObject()).applicationContext(this.applicationContext).build();
        return new AuthyAuthenticationWebflowEventResolver(context);
    }

    @ConditionalOnMissingBean(name={"authyMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer authyMultifactorWebflowConfigurer() {
        return new AuthyMultifactorWebflowConfigurer((FlowBuilderServices)this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)this.loginFlowDefinitionRegistry.getObject(), this.authyAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)this.applicationContext));
    }

    @RefreshScope
    @Bean
    public Action authyAuthenticationWebflowAction() {
        return new AuthyAuthenticationWebflowAction(this.authyAuthenticationWebflowEventResolver());
    }

    @Bean
    @ConditionalOnMissingBean(name={"authyCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer authyCasWebflowExecutionPlanConfigurer() {
        return plan -> plan.registerWebflowConfigurer(this.authyMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.authy", name={"trusted-device-enabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="authyMultifactorTrustConfiguration")
    public class AuthyMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"authyMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer authyMultifactorTrustWebflowConfigurer() {
            boolean deviceRegistrationEnabled = AuthyConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled();
            return new AuthyMultifactorTrustWebflowConfigurer((FlowBuilderServices)AuthyConfiguration.this.flowBuilderServices.getObject(), (FlowDefinitionRegistry)AuthyConfiguration.this.loginFlowDefinitionRegistry.getObject(), deviceRegistrationEnabled, AuthyConfiguration.this.authyAuthenticatorFlowRegistry(), AuthyConfiguration.this.applicationContext, AuthyConfiguration.this.casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)AuthyConfiguration.this.applicationContext));
        }

        @Bean
        @ConditionalOnMissingBean(name={"authyMultifactorTrustCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer authyMultifactorTrustCasWebflowExecutionPlanConfigurer() {
            return plan -> plan.registerWebflowConfigurer(this.authyMultifactorTrustWebflowConfigurer());
        }
    }
}

