/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config.support.authentication;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.authy.AuthyAuthenticationHandler;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.AuthyMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationRegistrationWebflowAction;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.AuthyMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.webflow.execution.Action;

@Configuration(value="authyAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AuthyAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthyAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @RefreshScope
    @Bean
    public AuthyClientInstance authyClientInstance() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        if (StringUtils.isBlank((CharSequence)authy.getApiKey())) {
            throw new IllegalArgumentException("Authy API key must be defined");
        }
        return new AuthyClientInstance(authy.getApiKey(), authy.getApiUrl(), authy.getMailAttribute(), authy.getPhoneAttribute(), authy.getCountryCode());
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler authyAuthenticationHandler() {
        AuthyMultifactorProperties authy = this.casProperties.getAuthn().getMfa().getAuthy();
        boolean forceVerification = authy.isForceVerification();
        return new AuthyAuthenticationHandler(authy.getName(), this.servicesManager, this.authyPrincipalFactory(), this.authyClientInstance(), forceVerification);
    }

    @ConditionalOnMissingBean(name={"authyPrincipalFactory"})
    @Bean
    public PrincipalFactory authyPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProvider authyAuthenticatorAuthenticationProvider() {
        AuthyMultifactorAuthenticationProvider p = new AuthyMultifactorAuthenticationProvider();
        p.setBypassEvaluator(this.authyBypassEvaluator());
        p.setGlobalFailureMode(this.casProperties.getAuthn().getMfa().getGlobalFailureMode());
        p.setOrder(this.casProperties.getAuthn().getMfa().getAuthy().getRank());
        p.setId(this.casProperties.getAuthn().getMfa().getAuthy().getId());
        return p;
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass authyBypassEvaluator() {
        return MultifactorAuthenticationUtils.newMultifactorAuthenticationProviderBypass((MultifactorAuthenticationProviderBypassProperties)this.casProperties.getAuthn().getMfa().getAuthy().getBypass());
    }

    @Bean
    @RefreshScope
    public AuthenticationMetaDataPopulator authyAuthenticationMetaDataPopulator() {
        return new AuthenticationContextAttributeMetaDataPopulator(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.authyAuthenticationHandler(), this.authyAuthenticatorAuthenticationProvider());
    }

    @RefreshScope
    @Bean
    public Action authyAuthenticationRegistrationWebflowAction() {
        return new AuthyAuthenticationRegistrationWebflowAction(this.authyClientInstance());
    }

    @ConditionalOnMissingBean(name={"authyAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer authyAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandler(this.authyAuthenticationHandler());
            plan.registerMetadataPopulator(this.authyAuthenticationMetaDataPopulator());
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{AuthyTokenCredential.class}));
        };
    }
}

