/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy.config;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowAction;
import org.apereo.cas.adaptors.authy.web.flow.AuthyAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.authy.web.flow.AuthyMultifactorWebflowConfigurer;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.authentication.RankedMultifactorAuthenticationProviderSelector;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@Configuration(value="authyConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AuthyConfiguration
implements CasWebflowExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthyConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport;
    @Autowired(required=false)
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector = new RankedMultifactorAuthenticationProviderSelector();
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;

    @Bean
    public FlowDefinitionRegistry authyAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.flowBuilderServices);
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-authy/*-webflow.xml");
        return builder.build();
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver authyAuthenticationWebflowEventResolver() {
        return new AuthyAuthenticationWebflowEventResolver(this.authenticationSystemSupport, this.centralAuthenticationService, this.servicesManager, this.ticketRegistrySupport, this.warnCookieGenerator, this.authenticationRequestServiceSelectionStrategies, this.multifactorAuthenticationProviderSelector);
    }

    @ConditionalOnMissingBean(name={"authyMultifactorWebflowConfigurer"})
    @Bean
    @DependsOn(value={"defaultWebflowConfigurer"})
    public CasWebflowConfigurer authyMultifactorWebflowConfigurer() {
        return new AuthyMultifactorWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.authyAuthenticatorFlowRegistry(), this.applicationContext, this.casProperties);
    }

    @RefreshScope
    @Bean
    public Action authyAuthenticationWebflowAction() {
        return new AuthyAuthenticationWebflowAction(this.authyAuthenticationWebflowEventResolver());
    }

    public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
        plan.registerWebflowConfigurer(this.authyMultifactorWebflowConfigurer());
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.authy", name={"trustedDeviceEnabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="authyMultifactorTrustConfiguration")
    public class AuthyMultifactorTrustConfiguration
    implements CasWebflowExecutionPlanConfigurer {
        @ConditionalOnMissingBean(name={"authyMultifactorTrustWebflowConfigurer"})
        @Bean
        @DependsOn(value={"defaultWebflowConfigurer"})
        public CasWebflowConfigurer authyMultifactorTrustWebflowConfigurer() {
            boolean deviceRegistrationEnabled = AuthyConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled();
            return new AuthyMultifactorTrustWebflowConfigurer(AuthyConfiguration.this.flowBuilderServices, AuthyConfiguration.this.loginFlowDefinitionRegistry, deviceRegistrationEnabled, AuthyConfiguration.this.authyAuthenticatorFlowRegistry(), AuthyConfiguration.this.applicationContext, AuthyConfiguration.this.casProperties);
        }

        public void configureWebflowExecutionPlan(CasWebflowExecutionPlan plan) {
            plan.registerWebflowConfigurer(this.authyMultifactorTrustWebflowConfigurer());
        }
    }
}

