/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.authy;

import com.authy.api.Error;
import com.authy.api.Token;
import com.authy.api.User;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.adaptors.authy.AuthyClientInstance;
import org.apereo.cas.adaptors.authy.AuthyTokenCredential;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthyAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthyAuthenticationHandler.class);
    private final boolean forceVerification;
    private final AuthyClientInstance instance;

    public AuthyAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, AuthyClientInstance instance, boolean forceVerification) {
        super(name, servicesManager, principalFactory, null);
        this.instance = instance;
        this.forceVerification = forceVerification;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        AuthyTokenCredential tokenCredential = (AuthyTokenCredential)credential;
        Authentication authentication = WebUtils.getInProgressAuthentication();
        if (authentication == null) {
            throw new IllegalArgumentException("CAS has no reference to an authentication event to locate a principal");
        }
        Principal principal = authentication.getPrincipal();
        User user = this.instance.getOrCreateUser(principal);
        if (!user.isOk()) {
            throw new FailedLoginException(AuthyClientInstance.getErrorMessage((Error)user.getError()));
        }
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("force", Boolean.toString(this.forceVerification));
        Token verification = this.instance.getAuthyTokens().verify(user.getId(), tokenCredential.getToken(), options);
        if (!verification.isOk()) {
            throw new FailedLoginException(AuthyClientInstance.getErrorMessage((Error)verification.getError()));
        }
        return this.createHandlerResult((Credential)tokenCredential, principal, new ArrayList());
    }

    public boolean supports(Credential credential) {
        return AuthyTokenCredential.class.isAssignableFrom(credential.getClass());
    }
}

