/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.zookeeper.graph.MergedLogSource;
import org.apache.zookeeper.graph.servlets.JsonServlet;

public class FileLoader
extends JsonServlet {
    private MergedLogSource source = null;

    public FileLoader(MergedLogSource src) throws Exception {
        this.source = src;
    }

    @Override
    String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        String file = request.getString("path", "/");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        try {
            this.source.addSource(file);
            rootNode.put("status", "OK");
        }
        catch (Exception e) {
            rootNode.put("status", "ERR");
            rootNode.put("error", e.toString());
        }
        String jsonString = mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)rootNode);
        return jsonString;
    }
}

