/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.graph.Log4JEntry;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.MergedLogSource;
import org.apache.zookeeper.graph.TransactionEntry;

public class JsonGenerator {
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonNode root;
    private final Set<Integer> servers = new HashSet<Integer>();

    public JsonNode txnEntry(TransactionEntry e) {
        ObjectNode event = this.mapper.createObjectNode();
        event.put("time", Long.toString(e.getTimestamp()));
        event.put("client", Long.toHexString(e.getClientId()));
        event.put("cxid", Long.toHexString(e.getCxid()));
        event.put("zxid", Long.toHexString(e.getZxid()));
        event.put("op", e.getOp());
        event.put("extra", e.getExtra());
        event.put("type", "transaction");
        return event;
    }

    public JsonGenerator(LogIterator iter) {
        Pattern stateChangeP = Pattern.compile("- (LOOKING|FOLLOWING|LEADING)");
        Pattern newElectionP = Pattern.compile("New election. My id =  (\\d+), Proposed zxid = (\\d+)");
        Pattern receivedProposalP = Pattern.compile("Notification: (\\d+) \\(n.leader\\), (\\d+) \\(n.zxid\\), (\\d+) \\(n.round\\), .+ \\(n.state\\), (\\d+) \\(n.sid\\), .+ \\(my state\\)");
        Pattern exceptionP = Pattern.compile("xception");
        this.root = this.mapper.createObjectNode();
        Matcher m = null;
        ArrayNode events = this.mapper.createArrayNode();
        ((ObjectNode)this.root).set("events", (JsonNode)events);
        long starttime = Long.MAX_VALUE;
        long endtime = 0L;
        int leader = 0;
        long curEpoch = 0L;
        while (iter.hasNext()) {
            LogEntry ent = (LogEntry)iter.next();
            if (ent.getTimestamp() < starttime) {
                starttime = ent.getTimestamp();
            }
            if (ent.getTimestamp() > endtime) {
                endtime = ent.getTimestamp();
            }
            if (ent.getType() == LogEntry.Type.TXN) {
                events.add(this.txnEntry((TransactionEntry)ent));
            } else {
                Log4JEntry e = (Log4JEntry)ent;
                this.servers.add(e.getNode());
                m = stateChangeP.matcher(e.getEntry());
                if (m.find()) {
                    JsonNode stateChange = this.add("stateChange", e.getTimestamp(), e.getNode(), m.group(1));
                    events.add(stateChange);
                    if (m.group(1).equals("LEADING")) {
                        leader = e.getNode();
                    }
                } else {
                    long zxid;
                    m = newElectionP.matcher(e.getEntry());
                    if (m.find()) {
                        Iterator<Integer> iterator = this.servers.iterator();
                        zxid = Long.valueOf(m.group(2));
                        int count = (int)zxid;
                        int epoch = (int)Long.rotateRight(zxid, 32);
                        if (leader != 0 && (long)epoch > curEpoch) {
                            JsonNode stateChange = this.add("stateChange", e.getTimestamp(), leader, "INIT");
                            events.add(stateChange);
                            leader = 0;
                        }
                        while (iterator.hasNext()) {
                            int dst = iterator.next();
                            if (dst == e.getNode()) continue;
                            ObjectNode msg = this.mapper.createObjectNode();
                            msg.put("type", "postmessage");
                            msg.put("src", e.getNode());
                            msg.put("dst", dst);
                            msg.put("time", e.getTimestamp());
                            msg.put("zxid", m.group(2));
                            msg.put("count", count);
                            msg.put("epoch", epoch);
                            events.add((JsonNode)msg);
                        }
                    } else {
                        m = receivedProposalP.matcher(e.getEntry());
                        if (m.find()) {
                            int src = Integer.valueOf(m.group(4));
                            zxid = Long.valueOf(m.group(2));
                            int dst = e.getNode();
                            long epoch2 = Long.valueOf(m.group(3));
                            int count = (int)zxid;
                            int epoch = (int)Long.rotateRight(zxid, 32);
                            if (leader != 0 && (long)epoch > curEpoch) {
                                JsonNode stateChange = this.add("stateChange", e.getTimestamp(), leader, "INIT");
                                events.add(stateChange);
                                leader = 0;
                            }
                            if (src != dst) {
                                ObjectNode msg = this.mapper.createObjectNode();
                                msg.put("type", "delivermessage");
                                msg.put("src", src);
                                msg.put("dst", dst);
                                msg.put("time", e.getTimestamp());
                                msg.put("zxid", zxid);
                                msg.put("count", count);
                                msg.put("epoch", epoch);
                                msg.put("epoch2", epoch2);
                                events.add((JsonNode)msg);
                            }
                        } else {
                            m = exceptionP.matcher(e.getEntry());
                            if (m.find()) {
                                ObjectNode ex = this.mapper.createObjectNode();
                                ex.put("type", "exception");
                                ex.put("time", e.getTimestamp());
                                ex.put("server", e.getNode());
                                ex.put("text", e.getEntry());
                                events.add((JsonNode)ex);
                            }
                        }
                    }
                }
            }
            ObjectNode ex = this.mapper.createObjectNode();
            ex.put("type", "text");
            ex.put("time", ent.getTimestamp());
            String txt = ent.toString();
            ex.put("text", txt);
            events.add((JsonNode)ex);
        }
        ((ObjectNode)this.root).put("starttime", starttime);
        ((ObjectNode)this.root).put("endtime", endtime);
        ArrayNode serversarray = this.mapper.createArrayNode();
        ((ObjectNode)this.root).set("servers", (JsonNode)serversarray);
        Iterator<Integer> iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            serversarray.add(iterator.next());
        }
    }

    private JsonNode add(String type, long timestamp, int node, String entry) {
        ObjectNode stateChange = this.mapper.createObjectNode();
        stateChange.put("type", type);
        stateChange.put("time", timestamp);
        stateChange.put("server", node);
        stateChange.put("state", entry);
        return stateChange;
    }

    public String toString() {
        String jsonString = null;
        try {
            jsonString = this.mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)this.root);
        }
        catch (JsonProcessingException e) {
            jsonString = "{\"ERR\", " + e.getMessage() + "}";
        }
        return jsonString;
    }

    public static void main(String[] args) throws Exception {
        MergedLogSource src = new MergedLogSource(args);
        LogIterator iter = src.iterator();
        System.out.println(new JsonGenerator(iter));
    }

    private class Message {
        private int from;
        private int to;
        private long zxid;

        public Message(int from, int to, long zxid) {
            this.from = from;
            this.to = to;
            this.zxid = zxid;
        }

        public boolean equals(Message m) {
            return m.from == this.from && m.to == this.to && m.zxid == this.zxid;
        }
    }
}

