/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashSet;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.TransactionEntry;
import org.apache.zookeeper.graph.servlets.JsonServlet;

public class Throughput
extends JsonServlet {
    private static final int MS_PER_SEC = 1000;
    private static final int MS_PER_MIN = 60000;
    private static final int MS_PER_HOUR = 3600000;
    private LogSource source = null;

    public Throughput(LogSource src) throws Exception {
        this.source = src;
    }

    @Override
    public String handleRequest(JsonServlet.JsonRequest request) throws Exception {
        String scalestr;
        long startTime = 0L;
        long endTime = 0L;
        long period = 0L;
        long scale = 0L;
        startTime = request.getNumber("start", 0L);
        endTime = request.getNumber("end", 0L);
        period = request.getNumber("period", 0L);
        if (startTime == 0L) {
            startTime = this.source.getStartTime();
        }
        if (endTime == 0L) {
            endTime = period > 0L ? startTime + period : this.source.getEndTime();
        }
        scale = (scalestr = request.getString("scale", "minutes")).equals("seconds") ? 1000L : (scalestr.equals("hours") ? 3600000L : 60000L);
        LogIterator iter = this.source.iterator(startTime, endTime);
        String jsonString = this.getJSON(iter, scale);
        iter.close();
        return jsonString;
    }

    protected String getJSON(LogIterator iter, long scale) throws IOException {
        long current = 0L;
        long currentms = 0L;
        HashSet<Long> zxids_ms = new HashSet<Long>();
        long zxidCount = 0L;
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode events = mapper.createArrayNode();
        while (iter.hasNext()) {
            LogEntry e = (LogEntry)iter.next();
            if (e.getType() != LogEntry.Type.TXN) continue;
            TransactionEntry cxn = (TransactionEntry)e;
            long ms = cxn.getTimestamp();
            long inscale = ms / scale;
            if (currentms != ms && currentms != 0L) {
                zxidCount += (long)zxids_ms.size();
                zxids_ms.clear();
            }
            if (inscale != current && current != 0L) {
                ObjectNode node = mapper.createObjectNode();
                node.put("time", current * scale);
                node.put("count", zxidCount);
                events.add((JsonNode)node);
                zxidCount = 0L;
            }
            current = inscale;
            currentms = ms;
            zxids_ms.add(cxn.getZxid());
        }
        ObjectNode node = mapper.createObjectNode();
        node.put("time", current * scale);
        node.put("count", zxidCount);
        events.add((JsonNode)node);
        String jsonString = mapper.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)events);
        return jsonString;
    }
}

