/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.Log4JEntry;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSkipList;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.RandomAccessFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JSource
implements LogSource {
    private static final Logger LOG = LoggerFactory.getLogger(Log4JSource.class);
    private static final int skipN = 10000;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
    private LogSkipList skiplist = null;
    private String file = null;
    private long starttime = 0L;
    private long endtime = 0L;
    private int serverid = 0;
    private long size = 0L;
    private Pattern timep;

    @Override
    public boolean overlapsRange(long starttime, long endtime) {
        return starttime <= this.endtime && endtime >= this.starttime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getStartTime() {
        return this.starttime;
    }

    @Override
    public long getEndTime() {
        return this.endtime;
    }

    public LogSkipList getSkipList() {
        return this.skiplist;
    }

    @Override
    public LogIterator iterator(long starttime, long endtime) throws IllegalArgumentException {
        try {
            return this.iterator(starttime, endtime, null);
        }
        catch (FilterException fe) {
            assert (false);
            return null;
        }
    }

    @Override
    public LogIterator iterator(long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
        if (endtime < starttime) {
            throw new IllegalArgumentException("End time (" + endtime + ") must be greater or equal to starttime (" + starttime + ")");
        }
        return new Log4JSourceIterator(this, starttime, endtime, filter);
    }

    @Override
    public LogIterator iterator() throws IllegalArgumentException {
        return this.iterator(this.starttime, this.endtime + 1L);
    }

    public Log4JSource(String file) throws IOException {
        this.file = file;
        this.timep = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3})");
        this.skiplist = new LogSkipList();
        this.init();
    }

    private static long timestampFromText(SimpleDateFormat format, String s) {
        Date d = null;
        try {
            d = format.parse(s);
        }
        catch (ParseException e) {
            return 0L;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return c.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        File f = new File(this.file);
        RandomAccessFileReader in = new RandomAccessFileReader(f);
        SimpleDateFormat dateformat = new SimpleDateFormat(DATE_FORMAT);
        Pattern idp = Pattern.compile("\\[myid:(\\d+)\\]");
        long lastFp = in.getPosition();
        String line = in.readLine();
        Matcher m = null;
        if (line == null || !(m = this.timep.matcher(line)).lookingAt()) {
            throw new IOException("Invalid log format. First line doesn't start with time");
        }
        this.starttime = Log4JSource.timestampFromText(dateformat, m.group(1));
        String lastentry = line;
        try {
            while (line != null) {
                m = this.timep.matcher(line);
                if (m.lookingAt()) {
                    if (this.size % 10000L == 0L) {
                        long time = Log4JSource.timestampFromText(dateformat, m.group(1));
                        this.skiplist.addMark(time, lastFp, this.size);
                    }
                    ++this.size;
                    lastentry = line;
                }
                if (this.serverid == 0 && (m = idp.matcher(line)).find()) {
                    this.serverid = Integer.valueOf(m.group(1));
                }
                lastFp = in.getPosition();
                line = in.readLine();
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            in.close();
        }
        if (!(m = this.timep.matcher(lastentry)).lookingAt()) {
            throw new IOException("Invalid log format. Last line doesn't start with time");
        }
        this.endtime = Log4JSource.timestampFromText(dateformat, m.group(1));
    }

    public String toString() {
        return "Log4JSource(file=" + this.file + ", size=" + this.size + ", start=" + this.starttime + ", end=" + this.endtime + ", id=" + this.serverid + ")";
    }

    public static void main(String[] args) throws IOException {
        LogIterator iter;
        final Log4JSource s = new Log4JSource(args[0]);
        System.out.println(s);
        if (args.length == 3) {
            final long starttime = Long.valueOf(args[1]);
            final long endtime = Long.valueOf(args[2]);
            iter = s.iterator(starttime, endtime);
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    LogIterator iter = s.iterator(starttime, endtime);
                    System.out.println(iter);
                    try {
                        iter.close();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe.getMessage());
                    }
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    LogIterator iter = s.iterator(starttime, endtime);
                    System.out.println(iter);
                    try {
                        iter.close();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe.getMessage());
                    }
                }
            };
            Thread t3 = new Thread(){

                @Override
                public void run() {
                    LogIterator iter = s.iterator(starttime, endtime);
                    System.out.println(iter);
                }
            };
            t1.start();
            t2.start();
        } else {
            iter = s.iterator();
        }
        iter.close();
    }

    public int getServerId() {
        return this.serverid;
    }

    private class Log4JSourceIterator
    implements LogIterator {
        private RandomAccessFileReader in;
        private LogEntry next = null;
        private long starttime = 0L;
        private long endtime = 0L;
        private String buf = "";
        private Log4JSource src = null;
        private long skippedAtStart = 0L;
        private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        private FilterOp filter = null;

        public Log4JSourceIterator(Log4JSource src, long starttime, long endtime) throws IllegalArgumentException, FilterException {
            this(src, starttime, endtime, null);
        }

        public Log4JSourceIterator(Log4JSource src, long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
            LogEntry e;
            this.src = src;
            this.starttime = starttime;
            this.endtime = endtime;
            File f = new File(src.file);
            try {
                this.in = new RandomAccessFileReader(f);
            }
            catch (FileNotFoundException e2) {
                throw new IllegalArgumentException("Bad file passed in (" + src.file + ") cannot open:" + e2);
            }
            LogSkipList.Mark start = src.getSkipList().findMarkBefore(starttime);
            try {
                this.in.seek(start.getBytes());
                this.skippedAtStart = start.getEntriesSkipped();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while ((e = this.readNextEntry()) != null && e.getTimestamp() < endtime) {
                if (e.getTimestamp() >= starttime && (filter == null || filter.matches(e))) {
                    this.next = e;
                    return;
                }
                ++this.skippedAtStart;
            }
            this.filter = filter;
        }

        @Override
        public synchronized long size() throws IOException {
            LogEntry e;
            if (LOG.isTraceEnabled()) {
                LOG.trace("size() called");
            }
            if (this.endtime >= this.src.getEndTime()) {
                return this.src.size() - this.skippedAtStart;
            }
            long pos = this.in.getPosition();
            if (LOG.isTraceEnabled()) {
                LOG.trace("saved pos () = " + pos);
            }
            LogSkipList.Mark lastseg = this.src.getSkipList().findMarkBefore(this.endtime);
            this.in.seek(lastseg.getBytes());
            this.buf = "";
            long count = lastseg.getEntriesSkipped() - this.skippedAtStart;
            while ((e = this.readNextEntry()) != null) {
                if (LOG.isTraceEnabled()) {
                    // empty if block
                }
                if (e.getTimestamp() > this.endtime) break;
                ++count;
            }
            this.in.seek(pos);
            this.buf = "";
            if (LOG.isTraceEnabled()) {
                LOG.trace("size() = " + count);
            }
            return count;
        }

        private synchronized LogEntry readNextEntry() {
            try {
                try {
                    String line;
                    while ((line = this.in.readLine()) != null) {
                        Matcher m = this.src.timep.matcher(line);
                        if (m.lookingAt()) {
                            if (this.buf.length() > 0) {
                                Log4JEntry e = new Log4JEntry(Log4JSource.timestampFromText(this.dateformat, this.buf), this.src.getServerId(), this.buf);
                                this.buf = line;
                                return e;
                            }
                            this.buf = line;
                            continue;
                        }
                        if (this.buf.length() <= 0) continue;
                        this.buf = this.buf + line + "\n";
                    }
                }
                catch (EOFException line) {
                    // empty catch block
                }
                if (this.buf.length() > 0) {
                    Log4JEntry e = new Log4JEntry(Log4JSource.timestampFromText(this.dateformat, this.buf), this.src.getServerId(), this.buf);
                    this.buf = "";
                    return e;
                }
            }
            catch (Exception e) {
                LOG.error("Error reading next entry in file (" + this.src.file + "): " + e);
                return null;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LogEntry next() throws NoSuchElementException {
            LogEntry ret = this.next;
            LogEntry e = this.readNextEntry();
            if (this.filter != null) {
                try {
                    while (e != null && !this.filter.matches(e)) {
                        e = this.readNextEntry();
                    }
                }
                catch (FilterException fe) {
                    throw new NoSuchElementException(e.toString());
                }
            }
            this.next = e != null && e.getTimestamp() < this.endtime ? e : null;
            return ret;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove not supported for L4J logs");
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public String toString() {
            String size;
            try {
                size = new Long(this.size()).toString();
            }
            catch (IOException ioe) {
                size = "Unable to read";
            }
            return "Log4JSourceIterator(start=" + this.starttime + ", end=" + this.endtime + ", size=" + size + ")";
        }
    }
}

