/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SqlSplitter {
    private Set<String> singleLineCommentPrefixList = new HashSet<String>();

    public SqlSplitter() {
        this.singleLineCommentPrefixList.add("--");
    }

    public SqlSplitter(String ... additionalSingleCommentPrefixList) {
        for (String singleLineCommentPrefix : additionalSingleCommentPrefixList) {
            if (singleLineCommentPrefix.length() > 2) {
                throw new RuntimeException("Invalid singleLineCommentPrefix: " + singleLineCommentPrefix + ", it is at most 2 characters");
            }
            this.singleLineCommentPrefixList.add(singleLineCommentPrefix);
        }
    }

    public List<String> splitSql(String text) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        boolean multiLineComment = false;
        boolean singleLineComment = false;
        boolean singleQuoteString = false;
        boolean doubleQuoteString = false;
        for (int index = 0; index < text.length(); ++index) {
            char character = text.charAt(index);
            if (singleLineComment && character == '\n') {
                singleLineComment = false;
                query.append(character);
                continue;
            }
            if (multiLineComment && index - 1 >= 0 && text.charAt(index - 1) == '/' && index - 2 >= 0 && text.charAt(index - 2) == '*') {
                multiLineComment = false;
            }
            if (character == '\'') {
                if (singleQuoteString) {
                    singleQuoteString = false;
                } else if (!doubleQuoteString) {
                    singleQuoteString = true;
                }
            }
            if (character == '\"') {
                if (doubleQuoteString && index > 0) {
                    doubleQuoteString = false;
                } else if (!singleQuoteString) {
                    doubleQuoteString = true;
                }
            }
            if (!(singleQuoteString || doubleQuoteString || multiLineComment || singleLineComment || text.length() <= index + 1)) {
                if (this.isSingleLineComment(text.charAt(index), text.charAt(index + 1))) {
                    singleLineComment = true;
                } else if (text.charAt(index) == '/' && text.length() > index + 2 && text.charAt(index + 1) == '*' && text.charAt(index + 2) != '+') {
                    multiLineComment = true;
                }
            }
            if (!(character != ';' || singleQuoteString || doubleQuoteString || multiLineComment || singleLineComment)) {
                if (query.toString().trim().isEmpty()) continue;
                queries.add(query.toString());
                query = new StringBuilder();
                continue;
            }
            if (index == text.length() - 1) {
                if (!singleLineComment && !multiLineComment) {
                    query.append(character);
                }
                if (query.toString().trim().isEmpty()) continue;
                queries.add(query.toString());
                query = new StringBuilder();
                continue;
            }
            if (!singleLineComment && !multiLineComment) {
                query.append(character);
                continue;
            }
            if (character != '\n') continue;
            query.append(character);
        }
        ArrayList<String> refinedQueries = new ArrayList<String>();
        for (int i = 0; i < queries.size(); ++i) {
            String emptyLine = "";
            if (i > 0) {
                emptyLine = this.createEmptyLine((String)refinedQueries.get(i - 1));
            }
            if (this.isSingleLineComment((String)queries.get(i)) || this.isMultipleLineComment((String)queries.get(i))) {
                if (refinedQueries.size() <= 0) continue;
                String lastRefinedQuery = (String)refinedQueries.get(refinedQueries.size() - 1);
                refinedQueries.set(refinedQueries.size() - 1, lastRefinedQuery + this.createEmptyLine((String)queries.get(i)));
                continue;
            }
            String refinedQuery = emptyLine + (String)queries.get(i);
            refinedQueries.add(refinedQuery);
        }
        return refinedQueries;
    }

    private boolean isSingleLineComment(String text) {
        return text.trim().startsWith("--");
    }

    private boolean isMultipleLineComment(String text) {
        return text.trim().startsWith("/*") && text.trim().endsWith("*/");
    }

    private String createEmptyLine(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    private boolean isSingleLineComment(char curChar, char nextChar) {
        for (String singleCommentPrefix : this.singleLineCommentPrefixList) {
            if (singleCommentPrefix.length() == 1 && curChar == singleCommentPrefix.charAt(0)) {
                return true;
            }
            if (singleCommentPrefix.length() != 2 || curChar != singleCommentPrefix.charAt(0) || nextChar != singleCommentPrefix.charAt(1)) continue;
            return true;
        }
        return false;
    }
}

