/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterUtils.class);

    private RemoteInterpreterUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int findRandomAvailablePortOnAllLocalInterfaces() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findAvailablePort(String portRange) throws IOException {
        if (StringUtils.isBlank((CharSequence)portRange) || portRange.equals(":")) {
            try (ServerSocket socket = new ServerSocket(0);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                throw new IOException("Failed to allocate a automatic port", e);
            }
        }
        int start = 1024;
        int end = 65535;
        String[] ports = portRange.split(":", -1);
        if (!ports[0].isEmpty()) {
            start = Integer.parseInt(ports[0]);
        }
        if (!ports[1].isEmpty()) {
            end = Integer.parseInt(ports[1]);
        }
        int i = start;
        while (i <= end) {
            try (ServerSocket socket = new ServerSocket(i);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        throw new IOException("No available port in the portRange: " + portRange);
    }

    public static String findAvailableHostAddress() throws UnknownHostException, SocketException {
        String zeppelinServerIP = System.getenv("ZEPPELIN_LOCAL_IP");
        if (zeppelinServerIP != null) {
            return zeppelinServerIP;
        }
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isLoopback()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress a = interfaceAddress.getAddress();
                    if (!(a instanceof Inet4Address)) continue;
                    return a.getHostAddress();
                }
            }
        }
        return address.getHostAddress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIfRemoteEndpointAccessible(String host, int port) {
        try (Socket discover = new Socket();){
            discover.setSoTimeout(1000);
            discover.connect(new InetSocketAddress(host, port), 1000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Remote endpoint '{}:{}' is not accessible (might be initializing): {}", new Object[]{host, port, e.getMessage()});
            return false;
        }
    }

    public static String getInterpreterSettingId(String intpGrpId) {
        String settingId = null;
        if (intpGrpId != null) {
            int indexOfColon = intpGrpId.indexOf(45);
            settingId = intpGrpId.substring(0, indexOfColon);
        }
        return settingId;
    }

    public static boolean isEnvString(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return key.matches("^[A-Z_0-9]*");
    }
}

