/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.zeppelin.interpreter.remote.RemoteClientFactory;
import org.apache.zeppelin.interpreter.remote.SupplierWithIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledRemoteClient<T extends TServiceClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledRemoteClient.class);
    private static final int RETRY_COUNT = 3;
    private GenericObjectPool<T> clientPool;
    private RemoteClientFactory<T> remoteClientFactory;

    public PooledRemoteClient(SupplierWithIO<T> supplier, int connectionPoolSize) {
        this.remoteClientFactory = new RemoteClientFactory<T>(supplier);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(connectionPoolSize);
        poolConfig.setMaxIdle(connectionPoolSize);
        this.clientPool = new GenericObjectPool(this.remoteClientFactory, poolConfig);
    }

    public PooledRemoteClient(SupplierWithIO<T> supplier) {
        this(supplier, 10);
    }

    public synchronized T getClient() throws Exception {
        TServiceClient t = (TServiceClient)this.clientPool.borrowObject(5000L);
        return (T)t;
    }

    public void shutdown() {
        if (this.remoteClientFactory != null) {
            this.remoteClientFactory.close();
        }
    }

    private void releaseClient(T client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject(client);
            }
            catch (Exception e) {
                LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
            }
        }
    }

    private void releaseBrokenClient(T client) {
        try {
            LOGGER.warn("release broken client");
            this.clientPool.invalidateObject(client);
        }
        catch (Exception e) {
            LOGGER.warn("exception occurred during releasing thrift client", (Throwable)e);
        }
    }

    public <R> R callRemoteFunction(RemoteFunction<R, T> func) {
        boolean broken = false;
        for (int i = 0; i < 3; ++i) {
            T client = null;
            broken = false;
            try {
                client = this.getClient();
                if (client == null) continue;
                R r = func.call(client);
                return r;
            }
            catch (TException e) {
                broken = true;
                continue;
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            finally {
                if (client != null) {
                    this.releaseClient(client, broken);
                }
            }
        }
        if (broken) {
            throw new RuntimeException("Fail to callRemoteFunction, because connection is broken");
        }
        return null;
    }

    public static interface RemoteFunction<R, T> {
        public R call(T var1) throws Exception;
    }
}

