/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.thrift.LibraryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterDownloader.class);
    private static final int MAX_LIBRARY_DOWNLOAD_ATTEMPTS = 3;
    private final RemoteInterpreterEventClient client;
    private final String interpreter;
    private final File localRepoDir;

    public RemoteInterpreterDownloader(String interpreter, RemoteInterpreterEventClient client, File localRepoDir) {
        this.client = client;
        this.interpreter = interpreter;
        this.localRepoDir = localRepoDir;
    }

    public static void main(String[] args) {
        if (args.length == 4) {
            String zeppelinServerHost = args[0];
            int port = Integer.parseInt(args[1]);
            String interpreter = args[2];
            String localRepoPath = args[3];
            RemoteInterpreterEventClient intpEventClient = new RemoteInterpreterEventClient(zeppelinServerHost, port, 3);
            RemoteInterpreterDownloader downloader = new RemoteInterpreterDownloader(interpreter, intpEventClient, new File(localRepoPath));
            downloader.syncAllLibraries();
        } else {
            LOGGER.error("Wrong amount of Arguments. Expected: [ZeppelinHostname] [ZeppelinPort] [InterpreterName] [LocalRepoPath]");
            System.exit(64);
        }
    }

    private void syncAllLibraries() {
        LOGGER.info("Loading all libraries for interpreter {} to {}", (Object)this.interpreter, (Object)this.localRepoDir);
        List<LibraryMetadata> metadatas = this.client.getAllLibraryMetadatas(this.interpreter);
        if (!this.localRepoDir.isDirectory()) {
            LOGGER.error("{} is no directory", (Object)this.localRepoDir);
            return;
        }
        HashSet<String> syncedLibraries = new HashSet<String>();
        for (LibraryMetadata metadata : metadatas) {
            File library = new File(this.localRepoDir, metadata.getName());
            this.addOrUpdateLibrary(library, metadata);
            syncedLibraries.add(metadata.getName());
        }
        for (File file : FileUtils.listFiles((File)this.localRepoDir, (String[])new String[]{"jar"}, (boolean)false)) {
            if (syncedLibraries.contains(file.getName())) continue;
            try {
                LOGGER.info("Delete {}, because it's not present on the server side", (Object)file.toPath());
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error("Unable to delete old library {} during sync.", (Object)file, (Object)e);
            }
        }
    }

    private void addOrUpdateLibrary(File library, LibraryMetadata metadata) {
        try {
            if (library.exists() && library.canRead()) {
                long localChecksum = FileUtils.checksumCRC32((File)library);
                if (localChecksum == metadata.getChecksum()) {
                    LOGGER.info("Library {} is present ", (Object)library.getName());
                } else {
                    Files.delete(library.toPath());
                    this.downloadLibrary(library, metadata);
                }
            } else {
                this.downloadLibrary(library, metadata);
            }
        }
        catch (IOException e) {
            LOGGER.error("Can not add or update library {}", (Object)library, (Object)e);
        }
    }

    private void downloadLibrary(File library, LibraryMetadata metadata) {
        block6: {
            LOGGER.debug("Trying to download library {} to {}", (Object)metadata.getName(), (Object)library);
            try {
                if (library.createNewFile()) {
                    int attempt = 0;
                    while (attempt < 3) {
                        ByteBuffer bytes = this.client.getLibrary(this.interpreter, metadata.getName());
                        if (bytes == null) {
                            LOGGER.error("ByteBuffer of library {} is null. For a detailed message take a look into Zeppelin-Server log. Attempt {} of {}", new Object[]{metadata.getName(), ++attempt, 3});
                            continue;
                        }
                        FileUtils.writeByteArrayToFile((File)library, (byte[])bytes.array());
                        if (FileUtils.checksumCRC32((File)library) == metadata.getChecksum()) {
                            LOGGER.info("Library {} successfully transfered", (Object)library.getName());
                            break block6;
                        }
                        LOGGER.error("Library Checksum didn't match. Attempt {} of {}", (Object)(++attempt), (Object)3);
                    }
                    break block6;
                }
                LOGGER.error("Unable to create a new library file {}", (Object)library);
            }
            catch (IOException e) {
                LOGGER.error("Unable to download Library {}", (Object)metadata.getName(), (Object)e);
            }
        }
    }
}

