/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import org.apache.zeppelin.helium.Application;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.resource.ResourceSet;

public class ClassLoaderApplication
extends Application {
    Application app;
    ClassLoader cl;

    public ClassLoaderApplication(Application app, ClassLoader cl) throws ApplicationException {
        super(app.context());
        this.app = app;
        this.cl = cl;
    }

    @Override
    public void run(ResourceSet args) throws ApplicationException {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.app.run(args);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    @Override
    public void unload() throws ApplicationException {
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            this.app.unload();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public Application getInnerApplication() {
        return this.app;
    }
}

