/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.conf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinLocationStrategy
implements FileLocationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinLocationStrategy.class);

    public URL locate(FileSystem fileSystem, FileLocator locator) {
        try {
            String zconfDir;
            File file;
            Map procEnv = EnvironmentUtils.getProcEnvironment();
            if (procEnv.containsKey("ZEPPELIN_HOME") && (file = new File((zconfDir = (String)procEnv.get("ZEPPELIN_HOME")) + File.separator + "conf" + File.separator + locator.getFileName())).isFile()) {
                LOGGER.info("Load configuration from {}", (Object)file);
                return file.toURI().toURL();
            }
            if (procEnv.containsKey("ZEPPELIN_CONF_DIR") && (file = new File((zconfDir = (String)procEnv.get("ZEPPELIN_CONF_DIR")) + File.separator + locator.getFileName())).isFile()) {
                LOGGER.info("Load configuration from {}", (Object)file);
                return file.toURI().toURL();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

