/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.maven.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class Utils {
    private static final int BUFFER_SIZE = 8192;
    private ZipInputStream zipFile = new ZipInputStream(this.getClass().getClassLoader().getResourceAsStream("yetus-bin.zip"));
    private File binDir;

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public Utils() {
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public int execCmd(String cmd, String ... args) throws IOException, InterruptedException {
        File cmdFile = new File(this.binDir, cmd);
        String realCmd = cmdFile.toString();
        String[] params = args;
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(args));
        list.add(0, realCmd);
        params = list.toArray(new String[list.size()]);
        ProcessBuilder pb = new ProcessBuilder(params);
        pb.inheritIO();
        Process p = pb.start();
        return p.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public void extractYetus(File destDir) throws IOException {
        this.binDir = new File(destDir, "bin");
        if (this.binDir.isDirectory()) {
            return;
        }
        try {
            ZipEntry entry;
            while ((entry = this.zipFile.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File file = new File(destDir, entry.getName());
                if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                    throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                }
                try (FileOutputStream out = new FileOutputStream(file);){
                    int i;
                    byte[] buffer = new byte[8192];
                    while ((i = this.zipFile.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, i);
                    }
                }
                file.setExecutable(true);
                file.setReadable(true);
                file.setWritable(true);
            }
        }
        finally {
            this.zipFile.close();
        }
    }
}

