/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.maven.plugin.fileops;

import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Mojo(name="symlink", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class CreateSymLinkMojo
extends AbstractMojo {
    @Parameter
    private String target;
    @Parameter
    private String newLink;
    @Parameter(defaultValue="true")
    private Boolean ignoreExist;
    @Parameter(defaultValue="${project.build.directory}")
    private String basedir;

    public void execute() throws MojoExecutionException {
        if (this.target == null) {
            throw new MojoExecutionException("target of symlink is undefined.");
        }
        if (this.newLink == null) {
            throw new MojoExecutionException("newLink of symlink is undefined.");
        }
        Path targetPath = Paths.get(this.target, new String[0]);
        Path newLinkPath = Paths.get(this.newLink, new String[0]);
        if (!newLinkPath.isAbsolute()) {
            newLinkPath = Paths.get(this.basedir, this.newLink);
        }
        try {
            Files.createSymbolicLink(newLinkPath, targetPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException x) {
            if (!this.ignoreExist.booleanValue()) {
                throw new MojoExecutionException("Unable to create " + newLinkPath.toString() + ": " + targetPath.toString() + " " + x);
            }
        }
        catch (Exception x) {
            throw new MojoExecutionException("Unable to create " + newLinkPath.toString() + ": " + targetPath.toString() + " " + x);
        }
    }
}

