/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcExtensionException;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.BigDecimalParser;
import org.apache.xmlrpc.parser.BigIntegerParser;
import org.apache.xmlrpc.parser.BooleanParser;
import org.apache.xmlrpc.parser.ByteArrayParser;
import org.apache.xmlrpc.parser.CalendarParser;
import org.apache.xmlrpc.parser.DateParser;
import org.apache.xmlrpc.parser.DoubleParser;
import org.apache.xmlrpc.parser.FloatParser;
import org.apache.xmlrpc.parser.I1Parser;
import org.apache.xmlrpc.parser.I2Parser;
import org.apache.xmlrpc.parser.I4Parser;
import org.apache.xmlrpc.parser.I8Parser;
import org.apache.xmlrpc.parser.MapParser;
import org.apache.xmlrpc.parser.NodeParser;
import org.apache.xmlrpc.parser.NullParser;
import org.apache.xmlrpc.parser.ObjectArrayParser;
import org.apache.xmlrpc.parser.SerializableParser;
import org.apache.xmlrpc.parser.StringParser;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.serializer.BigDecimalSerializer;
import org.apache.xmlrpc.serializer.BigIntegerSerializer;
import org.apache.xmlrpc.serializer.BooleanSerializer;
import org.apache.xmlrpc.serializer.ByteArraySerializer;
import org.apache.xmlrpc.serializer.CalendarSerializer;
import org.apache.xmlrpc.serializer.DateSerializer;
import org.apache.xmlrpc.serializer.DoubleSerializer;
import org.apache.xmlrpc.serializer.FloatSerializer;
import org.apache.xmlrpc.serializer.I1Serializer;
import org.apache.xmlrpc.serializer.I2Serializer;
import org.apache.xmlrpc.serializer.I4Serializer;
import org.apache.xmlrpc.serializer.I8Serializer;
import org.apache.xmlrpc.serializer.ListSerializer;
import org.apache.xmlrpc.serializer.MapSerializer;
import org.apache.xmlrpc.serializer.NodeSerializer;
import org.apache.xmlrpc.serializer.NullSerializer;
import org.apache.xmlrpc.serializer.ObjectArraySerializer;
import org.apache.xmlrpc.serializer.SerializableSerializer;
import org.apache.xmlrpc.serializer.StringSerializer;
import org.apache.xmlrpc.serializer.TypeSerializer;
import org.apache.xmlrpc.util.XmlRpcDateTimeDateFormat;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TypeFactoryImpl
implements TypeFactory {
    private static final TypeSerializer NULL_SERIALIZER = new NullSerializer();
    private static final TypeSerializer STRING_SERIALIZER = new StringSerializer();
    private static final TypeSerializer I4_SERIALIZER = new I4Serializer();
    private static final TypeSerializer BOOLEAN_SERIALIZER = new BooleanSerializer();
    private static final TypeSerializer DOUBLE_SERIALIZER = new DoubleSerializer();
    private static final TypeSerializer BYTE_SERIALIZER = new I1Serializer();
    private static final TypeSerializer SHORT_SERIALIZER = new I2Serializer();
    private static final TypeSerializer LONG_SERIALIZER = new I8Serializer();
    private static final TypeSerializer FLOAT_SERIALIZER = new FloatSerializer();
    private static final TypeSerializer NODE_SERIALIZER = new NodeSerializer();
    private static final TypeSerializer SERIALIZABLE_SERIALIZER = new SerializableSerializer();
    private static final TypeSerializer BIGDECIMAL_SERIALIZER = new BigDecimalSerializer();
    private static final TypeSerializer BIGINTEGER_SERIALIZER = new BigIntegerSerializer();
    private static final TypeSerializer CALENDAR_SERIALIZER = new CalendarSerializer();
    private final XmlRpcController controller;
    private DateSerializer dateSerializer;

    public TypeFactoryImpl(XmlRpcController pController) {
        this.controller = pController;
    }

    public XmlRpcController getController() {
        return this.controller;
    }

    public TypeSerializer getSerializer(XmlRpcStreamConfig pConfig, Object pObject) throws SAXException {
        if (pObject == null) {
            if (pConfig.isEnabledForExtensions()) {
                return NULL_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Null values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof String) {
            return STRING_SERIALIZER;
        }
        if (pObject instanceof Byte) {
            if (pConfig.isEnabledForExtensions()) {
                return BYTE_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Byte values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Short) {
            if (pConfig.isEnabledForExtensions()) {
                return SHORT_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Short values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Integer) {
            return I4_SERIALIZER;
        }
        if (pObject instanceof Long) {
            if (pConfig.isEnabledForExtensions()) {
                return LONG_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Long values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Boolean) {
            return BOOLEAN_SERIALIZER;
        }
        if (pObject instanceof Float) {
            if (pConfig.isEnabledForExtensions()) {
                return FLOAT_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Float values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Double) {
            return DOUBLE_SERIALIZER;
        }
        if (pObject instanceof Calendar) {
            if (pConfig.isEnabledForExtensions()) {
                return CALENDAR_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Calendar values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Date) {
            if (this.dateSerializer == null) {
                this.dateSerializer = new DateSerializer(new XmlRpcDateTimeDateFormat(){
                    private static final long serialVersionUID = 24345909123324234L;

                    protected TimeZone getTimeZone() {
                        return TypeFactoryImpl.this.controller.getConfig().getTimeZone();
                    }
                });
            }
            return this.dateSerializer;
        }
        if (pObject instanceof byte[]) {
            return new ByteArraySerializer();
        }
        if (pObject instanceof Object[]) {
            return new ObjectArraySerializer(this, pConfig);
        }
        if (pObject instanceof List) {
            return new ListSerializer(this, pConfig);
        }
        if (pObject instanceof Map) {
            return new MapSerializer(this, pConfig);
        }
        if (pObject instanceof Node) {
            if (pConfig.isEnabledForExtensions()) {
                return NODE_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("DOM nodes aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof BigInteger) {
            if (pConfig.isEnabledForExtensions()) {
                return BIGINTEGER_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("BigInteger values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof BigDecimal) {
            if (pConfig.isEnabledForExtensions()) {
                return BIGDECIMAL_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("BigDecimal values aren't supported, if isEnabledForExtensions() == false"));
        }
        if (pObject instanceof Serializable) {
            if (pConfig.isEnabledForExtensions()) {
                return SERIALIZABLE_SERIALIZER;
            }
            throw new SAXException(new XmlRpcExtensionException("Serializable objects aren't supported, if isEnabledForExtensions() == false"));
        }
        return null;
    }

    public TypeParser getParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, String pURI, String pLocalName) {
        if ("http://ws.apache.org/xmlrpc/namespaces/extensions".equals(pURI) || pConfig.isEnabledForExtensions() && !pConfig.isUseExtensionsNamespace()) {
            if (!pConfig.isEnabledForExtensions()) {
                return null;
            }
            if ("nil".equals(pLocalName)) {
                return new NullParser();
            }
            if ("i1".equals(pLocalName)) {
                return new I1Parser();
            }
            if ("i2".equals(pLocalName)) {
                return new I2Parser();
            }
            if ("i8".equals(pLocalName)) {
                return new I8Parser();
            }
            if ("float".equals(pLocalName)) {
                return new FloatParser();
            }
            if ("dom".equals(pLocalName)) {
                return new NodeParser();
            }
            if ("bigdecimal".equals(pLocalName)) {
                return new BigDecimalParser();
            }
            if ("biginteger".equals(pLocalName)) {
                return new BigIntegerParser();
            }
            if ("serializable".equals(pLocalName)) {
                return new SerializableParser();
            }
            if ("dateTime".equals(pLocalName)) {
                return new CalendarParser();
            }
        }
        if ("".equals(pURI) || "".equals(pURI) && pConfig.isEnabledForExtensions() && !pConfig.isUseExtensionsNamespace()) {
            if ("int".equals(pLocalName) || "i4".equals(pLocalName)) {
                return new I4Parser();
            }
            if ("boolean".equals(pLocalName)) {
                return new BooleanParser();
            }
            if ("double".equals(pLocalName)) {
                return new DoubleParser();
            }
            if ("dateTime.iso8601".equals(pLocalName)) {
                return new DateParser(new XmlRpcDateTimeDateFormat(){
                    private static final long serialVersionUID = 7585237706442299067L;

                    protected TimeZone getTimeZone() {
                        return TypeFactoryImpl.this.controller.getConfig().getTimeZone();
                    }
                });
            }
            if ("array".equals(pLocalName)) {
                return new ObjectArrayParser(pConfig, pContext, this);
            }
            if ("struct".equals(pLocalName)) {
                return new MapParser(pConfig, pContext, this);
            }
            if ("base64".equals(pLocalName)) {
                return new ByteArrayParser();
            }
            if ("string".equals(pLocalName)) {
                return new StringParser();
            }
        }
        return null;
    }
}

