/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultConfigurationBuilder {
    private static final Log LOG = LogFactory.getLog((String)DefaultConfigurationBuilder.class.getName());

    public DefaultConfiguration build(InputStream confStream) throws ConfigurationException {
        try {
            DocumentBuilder builder = DefaultConfiguration.DBF.newDocumentBuilder();
            Document document = builder.parse(confStream);
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration(document.getDocumentElement());
            return defaultConfiguration;
        }
        catch (DOMException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        finally {
            try {
                confStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public DefaultConfiguration buildFromFile(File file) throws ConfigurationException {
        try {
            DocumentBuilder builder = DefaultConfiguration.DBF.newDocumentBuilder();
            Document document = builder.parse(file);
            return new DefaultConfiguration(document.getDocumentElement());
        }
        catch (DOMException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("xml parse error", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("xml parse error", e);
        }
    }
}

