/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.StructureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageSequenceStructElem
extends PDFStructElem {
    private List<PDFStructElem> regionBefores = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionAfters = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionStarts = new ArrayList<PDFStructElem>();
    private List<PDFStructElem> regionEnds = new ArrayList<PDFStructElem>();

    PageSequenceStructElem(PDFObject parent, StructureType structureType) {
        super(parent, structureType);
    }

    void addContent(String flowName, PDFStructElem content) {
        if (flowName.equals("xsl-region-before")) {
            this.regionBefores.add(content);
        } else if (flowName.equals("xsl-region-after")) {
            this.regionAfters.add(content);
        } else if (flowName.equals("xsl-region-start")) {
            this.regionStarts.add(content);
        } else if (flowName.equals("xsl-region-end")) {
            this.regionEnds.add(content);
        } else {
            this.addKid(content);
        }
    }

    @Override
    protected boolean attachKids() {
        assert (!this.kids.isEmpty());
        PDFArray k = new PDFArray();
        this.addRegions(k, this.regionBefores);
        this.addRegions(k, this.regionStarts);
        this.addRegions(k, this.kids);
        this.addRegions(k, this.regionEnds);
        this.addRegions(k, this.regionAfters);
        this.put("K", k);
        return true;
    }

    private void addRegions(PDFArray k, List<? extends PDFObject> regions) {
        if (!regions.isEmpty()) {
            for (PDFObject pDFObject : regions) {
                k.add(pDFObject);
            }
        }
    }
}

