/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestException;
import org.apache.batik.test.TestSuite;
import org.apache.batik.test.xml.XMLReflect;
import org.apache.batik.test.xml.XTSConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTestSuiteLoader
implements XTSConstants {
    public static final String TEST_SUITE_LOADING_EXCEPTION = "xml.XMLTestSuiteLoader.error.test.suite.loading.exception";
    public static final String CANNOT_CREATE_TEST = "xml.XMLTestSuiteLoader.error.cannot.create.test";

    public static TestSuite loadTestSuite(String testSuiteURI, TestSuite parent) throws TestException {
        Document testSuiteDocument = XMLTestSuiteLoader.loadTestSuiteDocument(testSuiteURI);
        return XMLTestSuiteLoader.buildTestSuite(testSuiteDocument.getDocumentElement(), parent);
    }

    protected static Document loadTestSuiteDocument(String testSuiteURI) throws TestException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = docBuilder.parse(testSuiteURI);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException(TEST_SUITE_LOADING_EXCEPTION, new Object[]{testSuiteURI, e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
        return doc;
    }

    protected static TestSuite buildTestSuite(Element element, TestSuite parent) throws TestException {
        DefaultTestSuite testSuite = new DefaultTestSuite();
        String suiteId = element.getAttribute("id");
        testSuite.setId(suiteId);
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Test t;
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element childElement = (Element)child;
                String tagName = childElement.getTagName().intern();
                if (tagName == "test") {
                    t = XMLTestSuiteLoader.buildTest(childElement);
                    testSuite.addTest(t);
                    continue;
                }
                if (tagName != "testGroup") continue;
                t = XMLTestSuiteLoader.buildTestSuite(childElement, testSuite);
                testSuite.addTest(t);
            }
        }
        return testSuite;
    }

    protected static Test buildTest(Element element) throws TestException {
        try {
            Test t = (Test)XMLReflect.buildObject(element);
            String id = element.getAttribute("id");
            t.setId(id);
            return t;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            throw new TestException(CANNOT_CREATE_TEST, new Object[]{element.getAttribute("class"), e.getClass().getName(), e.getMessage(), sw.toString()}, e);
        }
    }
}

