/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import org.apache.xbean.command.Command;
import org.apache.xbean.command.CommandRegistry;

public class Lookup
implements Command {
    private final Context ctx;
    private static String PWD = "";

    public Lookup() throws Exception {
        this(new InitialContext());
    }

    public Lookup(Context ctx) {
        this.ctx = ctx;
    }

    public static void register() {
        try {
            Lookup cmd = new Lookup();
            CommandRegistry.register("lookup", cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int main(String[] args, InputStream in, PrintStream out) {
        try {
            String name = "";
            name = args == null || args.length == 0 ? PWD : args[0];
            Object obj = null;
            try {
                obj = this.ctx.lookup(name);
            }
            catch (NameNotFoundException e) {
                out.print("lookup: ");
                out.print(name);
                out.println(": No such object or subcontext");
                return -1;
            }
            catch (Throwable e) {
                out.print("lookup: error: ");
                e.printStackTrace(new PrintStream(out));
                return -1;
            }
            if (obj instanceof Context) {
                this.list(name, in, out);
                return 0;
            }
            out.println("" + obj);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(out));
            return -2;
        }
    }

    public void list(String name, InputStream in, PrintStream out) throws IOException {
        try {
            NamingEnumeration<NameClassPair> names = null;
            try {
                names = this.ctx.list(name);
            }
            catch (NameNotFoundException e) {
                out.print("lookup: ");
                out.print(name);
                out.println(": No such object or subcontext");
                return;
            }
            catch (Throwable e) {
                out.print("lookup: error: ");
                e.printStackTrace(new PrintStream(out));
                return;
            }
            if (names == null) {
                return;
            }
            while (names.hasMore()) {
                NameClassPair entry = names.next();
                out.println(entry.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintStream(out));
        }
    }
}

