/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.command.Command;
import org.apache.xbean.command.Exit;
import org.apache.xbean.command.GroovySh;
import org.apache.xbean.command.Help;
import org.apache.xbean.command.Lookup;
import org.apache.xbean.command.Version;

public class CommandRegistry {
    protected static final HashMap commands = new HashMap();
    protected static final CommandRegistry unknownCommand;

    public static Map getCommandMap() {
        HashMap<String, Command> rc = new HashMap<String, Command>();
        Iterator iter = commands.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Command command = CommandRegistry.getCommand(name);
            rc.put(name, command);
        }
        return rc;
    }

    public static void register(String name, Command cmd) {
        commands.put(name, cmd);
    }

    public static void register(String name, Class cmd) {
        commands.put(name, cmd);
    }

    public static Command getCommand(String name) {
        Object cmd = commands.get(name);
        if (cmd instanceof Class) {
            cmd = CommandRegistry.loadCommand((Class)cmd);
            CommandRegistry.register(name, (Command)cmd);
        }
        return (Command)cmd;
    }

    protected static Command loadCommand(Class commandClass) {
        Command cmd = null;
        try {
            cmd = (Command)commandClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    protected static void loadCommandList() {
        Exit.register();
        Help.register();
        Lookup.register();
        Version.register();
        GroovySh.register();
    }

    static {
        CommandRegistry.loadCommandList();
        unknownCommand = new CommandRegistry();
    }
}

