/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2b;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.impl.MappingMetaData;
import org.apache.xbean.spring.context.impl.NamedConstructorArgs;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.apache.xbean.spring.context.impl.PropertyEditorHelper;
import org.apache.xbean.spring.context.v2.XBeanQNameHelper;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ComponentDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractApplicationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XBeanNamespaceHandler
implements NamespaceHandler {
    public static final String SPRING_SCHEMA = "http://xbean.apache.org/schemas/spring/1.0";
    public static final String SPRING_SCHEMA_COMPAT = "http://xbean.org/schemas/spring/1.0";
    private static final Log log;
    private static final String QNAME_ELEMENT = "qname";
    private static final String DESCRIPTION_ELEMENT = "description";
    protected static final String[] RESERVED_ELEMENT_NAMES;
    protected static final String[] RESERVED_BEAN_ATTRIBUTE_NAMES;
    private static final String JAVA_PACKAGE_PREFIX = "java://";
    private static final String BEAN_REFERENCE_PREFIX = "#";
    private static final String NULL_REFERENCE = "#null";
    private Set reservedElementNames = new HashSet<String>(Arrays.asList(RESERVED_ELEMENT_NAMES));
    private Set reservedBeanAttributeNames = new HashSet<String>(Arrays.asList(RESERVED_BEAN_ATTRIBUTE_NAMES));
    protected final NamedConstructorArgs namedConstructorArgs = new NamedConstructorArgs();
    private ParserContext parserContext;
    private XBeanQNameHelper qnameHelper;
    static /* synthetic */ Class class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;

    public void init() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parserContext = parserContext;
        this.qnameHelper = new XBeanQNameHelper(parserContext.getReaderContext());
        BeanDefinitionHolder holder = this.parseBeanFromExtensionElement(element);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)componentDefinition);
        return holder.getBeanDefinition();
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        throw new IllegalArgumentException("Cannot locate BeanDefinitionDecorator for " + (node instanceof Element ? "element" : "attribute") + " [" + node.getLocalName() + "].");
    }

    public static void configure(AbstractApplicationContext context, XmlBeanDefinitionReader reader) {
        reader.setNamespaceAware(true);
        reader.setValidationMode(3);
    }

    public static void registerCustomEditors(DefaultListableBeanFactory beanFactory) {
        PropertyEditorHelper.registerCustomEditors();
    }

    protected BeanDefinitionHolder parseBeanFromExtensionElement(Element element, String parentClass, String property) {
        String className;
        String localName;
        String uri = element.getNamespaceURI();
        MappingMetaData metadata = this.findNamespaceProperties(uri, localName = this.getLocalName(element));
        if (metadata != null && (className = this.getPropertyDescriptor(parentClass, property).getPropertyType().getName()) != null) {
            return this.parseBeanFromExtensionElement(element, metadata, className);
        }
        return null;
    }

    private BeanDefinitionHolder parseBeanFromExtensionElement(Element element, MappingMetaData metadata, String className) {
        Element original = this.cloneElement(element);
        element.setAttributeNS(null, "class", className);
        this.addSpringAttributeValues(className, element);
        BeanDefinitionHolder definition = this.parserContext.getDelegate().parseBeanDefinitionElement(element, null);
        this.addAttributeProperties(definition, metadata, className, original);
        this.addContentProperty(definition, metadata, element);
        this.addNestedPropertyElements(definition, metadata, className, element);
        this.qnameHelper.coerceNamespaceAwarePropertyValues(definition.getBeanDefinition(), element);
        this.declareLifecycleMethods(definition, metadata, element);
        this.resolveBeanClass((AbstractBeanDefinition)definition.getBeanDefinition(), definition.getBeanName());
        this.namedConstructorArgs.processParameters(definition, metadata);
        return definition;
    }

    protected Class resolveBeanClass(AbstractBeanDefinition bd, String beanName) {
        if (bd.hasBeanClass()) {
            return bd.getBeanClass();
        }
        try {
            ClassLoader cl = this.parserContext.getReaderContext().getReader().getBeanClassLoader();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return bd.resolveBeanClass(cl);
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Bean class [" + bd.getBeanClassName() + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Class that bean class [" + bd.getBeanClassName() + "] depends on not found", (Throwable)err);
        }
    }

    protected BeanDefinitionHolder parseBeanFromExtensionElement(Element element) {
        String localName;
        String uri = element.getNamespaceURI();
        MappingMetaData metadata = this.findNamespaceProperties(uri, localName = this.getLocalName(element));
        if (metadata != null) {
            String className = metadata.getClassName(localName);
            if (className != null) {
                return this.parseBeanFromExtensionElement(element, metadata, className);
            }
            throw new BeanDefinitionStoreException("Unrecognized xbean element mapping: " + localName + " in namespace " + uri);
        }
        if (uri == null) {
            throw new BeanDefinitionStoreException("Unrecognized Spring element: " + localName);
        }
        throw new BeanDefinitionStoreException("Unrecognized xbean namespace mapping: " + uri);
    }

    protected void addSpringAttributeValues(String className, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            String localName = attribute.getLocalName();
            if (uri == null || !uri.equals(SPRING_SCHEMA) && !uri.equals(SPRING_SCHEMA_COMPAT)) continue;
            element.setAttributeNS(null, localName, attribute.getNodeValue());
        }
    }

    protected Element cloneElement(Element element) {
        Element answer = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            answer.setAttributeNS(uri, attribute.getName(), attribute.getNodeValue());
        }
        return answer;
    }

    protected void addAttributeProperties(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        PropertyDescriptor descriptor;
        boolean addProperty;
        String localName;
        String uri;
        Attr attribute;
        int i;
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (i = 0; i < size; ++i) {
            attribute = (Attr)attributes.item(i);
            uri = attribute.getNamespaceURI();
            localName = attribute.getLocalName();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || !this.isEmpty(uri) || localName.equals("class")) continue;
            addProperty = true;
            if (this.reservedBeanAttributeNames.contains(localName)) {
                descriptor = this.getPropertyDescriptor(className, localName);
                boolean bl = addProperty = descriptor != null;
            }
            if (!addProperty) continue;
            this.addAttributeProperty(definition, metadata, element, attribute);
        }
        size = attributes.getLength();
        for (i = 0; i < size; ++i) {
            attribute = (Attr)attributes.item(i);
            uri = attribute.getNamespaceURI();
            localName = attribute.getLocalName();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || this.isEmpty(uri) || !uri.equals(element.getNamespaceURI())) continue;
            addProperty = true;
            if (this.reservedBeanAttributeNames.contains(localName)) {
                descriptor = this.getPropertyDescriptor(className, localName);
                boolean bl = addProperty = descriptor != null;
            }
            if (!addProperty) continue;
            this.addAttributeProperty(definition, metadata, element, attribute);
        }
    }

    protected void addContentProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element) {
        String name = metadata.getContentProperty(this.getLocalName(element));
        if (name != null) {
            String value = this.getElementText(element);
            this.addProperty(definition, metadata, element, name, value);
        } else {
            StringBuffer buffer = new StringBuffer();
            NodeList childNodes = element.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Text)) continue;
                buffer.append(((Text)node).getData());
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer.toString().getBytes());
            Properties properties = new Properties();
            try {
                properties.load(in);
            }
            catch (IOException e) {
                return;
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                String propertyEditor = metadata.getPropertyEditor(this.getLocalName(element), propertyName);
                Object value = this.getValue(properties.getProperty(propertyName), propertyEditor);
                definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, value);
            }
        }
    }

    protected void addAttributeProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, Attr attribute) {
        String localName = attribute.getLocalName();
        String value = attribute.getValue();
        this.addProperty(definition, metadata, element, localName, value);
    }

    protected void addProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, String localName, String value) {
        String propertyName = metadata.getPropertyName(this.getLocalName(element), localName);
        String propertyEditor = metadata.getPropertyEditor(this.getLocalName(element), propertyName);
        if (propertyName != null) {
            definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, this.getValue(value, propertyEditor));
        }
    }

    protected Object getValue(String value, String propertyEditor) {
        if (value == null) {
            return null;
        }
        if (NULL_REFERENCE.equals(value)) {
            return null;
        }
        if (value.startsWith(BEAN_REFERENCE_PREFIX) && !(value = value.substring(BEAN_REFERENCE_PREFIX.length())).startsWith(BEAN_REFERENCE_PREFIX)) {
            return new RuntimeBeanReference(value);
        }
        if (propertyEditor != null) {
            PropertyEditor p = this.createPropertyEditor(propertyEditor);
            p.setAsText(value);
            return p.getValue();
        }
        return value;
    }

    protected PropertyEditor createPropertyEditor(String propertyEditor) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler == null ? (class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler = XBeanNamespaceHandler.class$("org.apache.xbean.spring.context.v2b.XBeanNamespaceHandler")) : class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler).getClassLoader();
        }
        try {
            return (PropertyEditor)cl.loadClass(propertyEditor).newInstance();
        }
        catch (Throwable e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Could not load property editor: " + propertyEditor).initCause(e);
        }
    }

    protected String getLocalName(Element element) {
        String localName = element.getLocalName();
        if (localName == null) {
            localName = element.getNodeName();
        }
        return localName;
    }

    protected void addNestedPropertyElements(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (this.isEmpty(uri) && this.reservedElementNames.contains(localName)) continue;
            Object value = null;
            String propertyName = metadata.getNestedListProperty(this.getLocalName(element), localName);
            if (propertyName != null) {
                value = this.parseListElement(childElement, propertyName);
            } else {
                propertyName = metadata.getFlatCollectionProperty(this.getLocalName(element), localName);
                if (propertyName != null) {
                    Collection l;
                    BeanDefinitionHolder def = this.parseBeanFromExtensionElement(childElement);
                    PropertyValue pv = definition.getBeanDefinition().getPropertyValues().getPropertyValue(propertyName);
                    if (pv != null) {
                        l = (Collection)pv.getValue();
                        l.add(def);
                        continue;
                    }
                    l = new ManagedList();
                    ((ArrayList)l).add(def);
                    value = l;
                } else {
                    propertyName = metadata.getNestedProperty(this.getLocalName(element), localName);
                    if (propertyName != null) {
                        value = this.parseChildExtensionBean(childElement);
                    }
                }
            }
            if (propertyName == null && metadata.isFlatProperty(this.getLocalName(element), localName)) {
                value = this.parseBeanFromExtensionElement(childElement, className, localName);
                propertyName = localName;
            }
            if (propertyName == null) {
                value = this.tryParseNestedPropertyViaIntrospection(metadata, className, childElement);
                propertyName = localName;
            }
            if (value != null) {
                definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, value);
                continue;
            }
            String text = this.getElementText(childElement);
            if (text == null) continue;
            this.addProperty(definition, metadata, element, localName, text);
        }
    }

    protected Object tryParseNestedPropertyViaIntrospection(MappingMetaData metadata, String className, Element element) {
        String localName = this.getLocalName(element);
        PropertyDescriptor descriptor = this.getPropertyDescriptor(className, localName);
        if (descriptor != null) {
            return this.parseNestedPropertyViaIntrospection(metadata, element, descriptor.getName(), descriptor.getPropertyType());
        }
        return this.parseNestedPropertyViaIntrospection(metadata, element, localName, class$java$lang$Object == null ? (class$java$lang$Object = XBeanNamespaceHandler.class$("java.lang.Object")) : class$java$lang$Object);
    }

    protected PropertyDescriptor getPropertyDescriptor(String className, String localName) {
        BeanInfo beanInfo = this.qnameHelper.getBeanInfo(className);
        if (beanInfo != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (!name.equals(localName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    private Object parseNestedPropertyViaIntrospection(MappingMetaData metadata, Element element, String propertyName, Class propertyType) {
        if (this.isMap(propertyType)) {
            return this.parseCustomMapElement(metadata, element, propertyName);
        }
        if (this.isCollection(propertyType)) {
            return this.parseListElement(element, propertyName);
        }
        return this.parseChildExtensionBean(element);
    }

    protected Object parseListElement(Element element, String name) {
        return this.parserContext.getDelegate().parseListElement(element, null);
    }

    protected Object parseCustomMapElement(MappingMetaData metadata, Element element, String name) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Element parent = (Element)element.getParentNode();
        String entryName = metadata.getMapEntryName(this.getLocalName(parent), name);
        String keyName = metadata.getMapKeyName(this.getLocalName(parent), name);
        if (entryName == null) {
            entryName = "property";
        }
        if (keyName == null) {
            keyName = "key";
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String uri = childElement.getNamespaceURI();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || this.isEmpty(uri) || !localName.equals(entryName)) continue;
            String key = childElement.getAttribute(keyName);
            if (key == null) {
                throw new RuntimeException("No key defined for map " + entryName);
            }
            Object keyValue = this.getValue(key, null);
            Object value = this.getValue(this.getElementText(childElement), null);
            map.put(keyValue, value);
        }
        return map;
    }

    protected boolean isMap(Class type) {
        return (class$java$util$Map == null ? (class$java$util$Map = XBeanNamespaceHandler.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type);
    }

    protected boolean isCollection(Class type) {
        return type.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = XBeanNamespaceHandler.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type);
    }

    protected Object parseChildExtensionBean(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (uri == null || uri.equals(SPRING_SCHEMA) || uri.equals(SPRING_SCHEMA_COMPAT) || uri.equals("http://www.springframework.org/schema/beans")) {
                if ("bean".equals(localName)) {
                    return this.parserContext.getDelegate().parseBeanDefinitionElement(childElement, null);
                }
                return this.parserContext.getDelegate().parsePropertySubElement(childElement, null);
            }
            BeanDefinitionHolder value = this.parseBeanFromExtensionElement(childElement);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected MappingMetaData findNamespaceProperties(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.startsWith(JAVA_PACKAGE_PREFIX)) {
            String packageName = namespaceURI.substring(JAVA_PACKAGE_PREFIX.length());
            return new MappingMetaData(packageName);
        }
        String uri = NamespaceHelper.createDiscoveryPathName(namespaceURI, localName);
        InputStream in = this.loadResource(uri);
        if (in == null && namespaceURI != null && namespaceURI.length() > 0 && (in = this.loadResource(uri = NamespaceHelper.createDiscoveryPathName(namespaceURI))) == null) {
            uri = NamespaceHelper.createDiscoveryOldPathName(namespaceURI);
            in = this.loadResource(uri);
        }
        if (in != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                return new MappingMetaData(properties);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to load resource from uri: " + uri), (Throwable)e);
            }
        }
        return null;
    }

    protected InputStream loadResource(String uri) {
        InputStream in;
        if (System.getProperty("xbean.dir") != null) {
            File f = new File(System.getProperty("xbean.dir") + uri);
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri)) == null && (in = this.getClass().getClassLoader().getResourceAsStream(uri)) == null) {
            log.debug((Object)("Could not find resource: " + uri));
        }
        return in;
    }

    protected boolean isEmpty(String uri) {
        return uri == null || uri.length() == 0;
    }

    protected void declareLifecycleMethods(BeanDefinitionHolder definitionHolder, MappingMetaData metaData, Element element) {
        BeanDefinition definition = definitionHolder.getBeanDefinition();
        if (definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)definition;
            if (beanDefinition.getInitMethodName() == null) {
                beanDefinition.setInitMethodName(metaData.getInitMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getDestroyMethodName() == null) {
                beanDefinition.setDestroyMethodName(metaData.getDestroyMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getFactoryMethodName() == null) {
                beanDefinition.setFactoryMethodName(metaData.getFactoryMethodName(this.getLocalName(element)));
            }
        }
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorHelper.registerCustomEditors();
        log = LogFactory.getLog((Class)(class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler == null ? (class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler = XBeanNamespaceHandler.class$("org.apache.xbean.spring.context.v2b.XBeanNamespaceHandler")) : class$org$apache$xbean$spring$context$v2b$XBeanNamespaceHandler));
        RESERVED_ELEMENT_NAMES = new String[]{"beans", DESCRIPTION_ELEMENT, "import", "alias", "bean", "constructor-arg", "property", "lookup-method", "replaced-method", "arg-type", "ref", "idref", "value", "null", "list", "set", "map", "entry", "key", "props", "prop", QNAME_ELEMENT};
        RESERVED_BEAN_ATTRIBUTE_NAMES = new String[]{"id", "name", "class", "parent", "depends-on", "factory-method", "factory-bean", "dependency-check", "autowire", "init-method", "destroy-method", "abstract", "singleton", "lazy-init"};
    }
}

