/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.xbean.naming.context.NestedContextFactory;
import org.apache.xbean.naming.reference.SimpleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextUtil {
    public static final NameParser NAME_PARSER = new SimpleNameParser();

    private ContextUtil() {
    }

    public static Name parseName(String name) throws NamingException {
        return NAME_PARSER.parse(name);
    }

    public static Object resolve(Object value, String stringName, Name parsedName, Context nameCtx) throws NamingException {
        if (!(value instanceof Reference)) {
            return value;
        }
        Reference reference = (Reference)value;
        if (reference instanceof SimpleReference) {
            try {
                return ((SimpleReference)reference).getContent();
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("Could not look up : " + stringName == null ? parsedName.toString() : stringName).initCause(e);
            }
        }
        try {
            if (parsedName == null) {
                parsedName = NAME_PARSER.parse(stringName);
            }
            return NamingManager.getObjectInstance(reference, parsedName, nameCtx, nameCtx.getEnvironment());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Could not look up : " + stringName == null ? parsedName.toString() : stringName).initCause(e);
        }
    }

    public static Map<String, String> listToMap(NamingEnumeration enumeration) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            NameClassPair nameClassPair = (NameClassPair)enumeration.nextElement();
            String name = nameClassPair.getName();
            result.put(name, nameClassPair.getClassName());
        }
        return result;
    }

    public static Map<String, Object> listBindingsToMap(NamingEnumeration enumeration) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            Binding binding = (Binding)enumeration.nextElement();
            String name = binding.getName();
            result.put(name, binding.getObject());
        }
        return result;
    }

    public static Map<String, Object> createBindings(Map<String, Object> absoluteBindings, NestedContextFactory factory) throws NamingException {
        Node node = ContextUtil.buildMapTree(absoluteBindings);
        return ContextUtil.createBindings(null, node, factory);
    }

    private static Map<String, Object> createBindings(String nameInNameSpace, Node node, NestedContextFactory factory) throws NamingException {
        HashMap<String, Object> bindings = new HashMap<String, Object>(node.size());
        for (Map.Entry entry : node.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Node) {
                Node nestedNode = (Node)value;
                String path = nameInNameSpace == null ? name : nameInNameSpace + "/" + name;
                Map<String, Object> nestedBindings = ContextUtil.createBindings(path, nestedNode, factory);
                Context nestedContext = factory.createNestedSubcontext(path, nestedBindings);
                bindings.put(name, nestedContext);
                continue;
            }
            bindings.put(name, value);
        }
        return bindings;
    }

    public static Node buildMapTree(Map<String, Object> absoluteBindings) throws NamingException {
        Node rootContext = new Node();
        for (Map.Entry<String, Object> entry : absoluteBindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            Node parentContext = rootContext;
            Name compoundName = ContextUtil.parseName(name);
            Enumeration<String> parts = compoundName.getAll();
            while (parts.hasMoreElements()) {
                String part = parts.nextElement();
                if (!parts.hasMoreElements()) continue;
                Node bindings = (Node)parentContext.get(part);
                if (bindings == null) {
                    bindings = new Node();
                    parentContext.put(part, bindings);
                }
                parentContext = bindings;
            }
            parentContext.put(compoundName.get(compoundName.size() - 1), value);
        }
        return rootContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Node
    extends HashMap<String, Object> {
    }

    private static final class SimpleNameParser
    implements NameParser {
        private static final Properties PARSER_PROPERTIES = new Properties();

        private SimpleNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, PARSER_PROPERTIES);
        }

        static {
            PARSER_PROPERTIES.put("jndi.syntax.direction", "left_to_right");
            PARSER_PROPERTIES.put("jndi.syntax.separator", "/");
        }
    }

    public static final class ReadOnlyBinding
    extends Binding {
        private final Object value;
        private final Context context;
        private final boolean isRelative;

        public ReadOnlyBinding(String name, Object value, Context context) {
            this(name, value, false, context);
        }

        public ReadOnlyBinding(String name, Object value, boolean isRelative, Context context) {
            super(name, value);
            this.value = value;
            this.context = context;
            this.isRelative = isRelative;
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public String getClassName() {
            if (this.value instanceof Reference) {
                Reference reference = (Reference)this.value;
                return reference.getClassName();
            }
            return this.value.getClass().getName();
        }

        public void setClassName(String name) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public Object getObject() {
            try {
                return ContextUtil.resolve(this.value, this.getName(), null, this.context);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }

        public void setObject(Object obj) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean r) {
            throw new UnsupportedOperationException("Context is read only");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListBindingEnumeration
    implements NamingEnumeration<Binding> {
        private final Iterator iterator;
        private final Context context;

        public ListBindingEnumeration(Map localBindings, Context context) {
            this.iterator = localBindings.entrySet().iterator();
            this.context = context;
        }

        @Override
        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public Binding next() {
            return this.nextElement();
        }

        @Override
        public Binding nextElement() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            return new ReadOnlyBinding(name, value, this.context);
        }

        @Override
        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListEnumeration
    implements NamingEnumeration<NameClassPair> {
        private final Iterator iterator;

        public ListEnumeration(Map localBindings) {
            this.iterator = localBindings.entrySet().iterator();
        }

        @Override
        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public NameClassPair next() {
            return this.nextElement();
        }

        @Override
        public NameClassPair nextElement() {
            String className;
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Reference) {
                Reference reference = (Reference)value;
                className = reference.getClassName();
            } else {
                className = value.getClass().getName();
            }
            return new NameClassPair(name, className);
        }

        @Override
        public void close() {
        }
    }
}

