/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.xbean.naming.context.NestedContextFactory;
import org.apache.xbean.naming.reference.SimpleReference;

public final class ContextUtil {
    public static final NameParser NAME_PARSER = new SimpleNameParser();

    private ContextUtil() {
    }

    public static Name parseName(String name) throws NamingException {
        return NAME_PARSER.parse(name);
    }

    public static Object resolve(String name, Object value) throws NamingException {
        if (!(value instanceof Reference)) {
            return value;
        }
        Reference reference = (Reference)value;
        if (reference instanceof SimpleReference) {
            try {
                return ((SimpleReference)reference).getContent();
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("Could not look up : " + name).initCause(e);
            }
        }
        try {
            return NamingManager.getObjectInstance(reference, null, null, new Hashtable());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Could not look up : " + name).initCause(e);
        }
    }

    public static Map listToMap(NamingEnumeration enumeration) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            NameClassPair nameClassPair = (NameClassPair)enumeration.nextElement();
            String name = nameClassPair.getName();
            result.put(name, nameClassPair.getClassName());
        }
        return result;
    }

    public static Map listBindingsToMap(NamingEnumeration enumeration) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            Binding binding = (Binding)enumeration.nextElement();
            String name = binding.getName();
            result.put(name, binding.getObject());
        }
        return result;
    }

    public static Map createBindings(Map absoluteBindings, NestedContextFactory factory) throws NamingException {
        Node node = ContextUtil.buildMapTree(absoluteBindings);
        Map localBindings = ContextUtil.createBindings(null, node, factory);
        return localBindings;
    }

    private static Map createBindings(String nameInNameSpace, Node node, NestedContextFactory factory) throws NamingException {
        HashMap<String, Context> bindings = new HashMap<String, Context>(node.size());
        for (Map.Entry entry : node.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Node) {
                Node nestedNode = (Node)value;
                String path = nameInNameSpace == null ? name : nameInNameSpace + "/" + name;
                Map nestedBindings = ContextUtil.createBindings(path, nestedNode, factory);
                Context nestedContext = factory.createNestedSubcontext(path, nestedBindings);
                bindings.put(name, nestedContext);
                continue;
            }
            bindings.put(name, (Context)value);
        }
        return bindings;
    }

    public static Node buildMapTree(Map absoluteBindings) throws NamingException {
        Node rootContext = new Node();
        for (Map.Entry entry : absoluteBindings.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Node parentContext = rootContext;
            Name compoundName = ContextUtil.parseName(name);
            Enumeration<String> parts = compoundName.getAll();
            while (parts.hasMoreElements()) {
                String part = parts.nextElement();
                if (!parts.hasMoreElements()) continue;
                Node bindings = (Node)parentContext.get(part);
                if (bindings == null) {
                    bindings = new Node();
                    parentContext.put(part, bindings);
                }
                parentContext = bindings;
            }
            parentContext.put(compoundName.get(compoundName.size() - 1), value);
        }
        return rootContext;
    }

    public static final class Node
    extends HashMap {
    }

    private static final class SimpleNameParser
    implements NameParser {
        private static final Properties PARSER_PROPERTIES = new Properties();

        private SimpleNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, PARSER_PROPERTIES);
        }

        static {
            PARSER_PROPERTIES.put("jndi.syntax.direction", "left_to_right");
            PARSER_PROPERTIES.put("jndi.syntax.separator", "/");
        }
    }

    public static final class ReadOnlyBinding
    extends Binding {
        private final Object value;

        public ReadOnlyBinding(String name, Object value) {
            super(name, value);
            this.value = value;
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public String getClassName() {
            if (this.value instanceof Reference) {
                Reference reference = (Reference)this.value;
                return reference.getClassName();
            }
            return this.value.getClass().getName();
        }

        public void setClassName(String name) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public Object getObject() {
            try {
                return ContextUtil.resolve(this.getName(), this.value);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }

        public void setObject(Object obj) {
            throw new UnsupportedOperationException("Context is read only");
        }

        public boolean isRelative() {
            return false;
        }

        public void setRelative(boolean r) {
            throw new UnsupportedOperationException("Context is read only");
        }
    }

    public static final class ListBindingEnumeration
    implements NamingEnumeration {
        private final Iterator iterator;

        public ListBindingEnumeration(Map localBindings) {
            this.iterator = localBindings.entrySet().iterator();
        }

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            return new ReadOnlyBinding(name, value);
        }

        public void close() {
        }
    }

    public static final class ListEnumeration
    implements NamingEnumeration {
        private final Iterator iterator;

        public ListEnumeration(Map localBindings) {
            this.iterator = localBindings.entrySet().iterator();
        }

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String className = null;
            if (value instanceof Reference) {
                Reference reference = (Reference)value;
                className = reference.getClassName();
            } else {
                className = value.getClass().getName();
            }
            return new NameClassPair(name, className);
        }

        public void close() {
        }
    }
}

