/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.ContextFlyweight;

public class VirtualSubcontext
extends ContextFlyweight {
    private final Name nameInContext;
    private final Context context;

    public VirtualSubcontext(Name nameInContext, Context context) throws NamingException {
        if (context instanceof VirtualSubcontext) {
            VirtualSubcontext virtualSubcontext = (VirtualSubcontext)context;
            this.nameInContext = virtualSubcontext.getName(nameInContext);
            this.context = virtualSubcontext.context;
        } else {
            this.nameInContext = nameInContext;
            this.context = context;
        }
    }

    protected Context getContext() throws NamingException {
        return this.context;
    }

    protected Name getName(Name name) throws NamingException {
        return this.context.composeName(this.nameInContext, name);
    }

    protected String getName(String name) throws NamingException {
        Name parsedName = this.context.getNameParser("").parse(name);
        return this.context.composeName(this.nameInContext, parsedName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualSubcontext that = (VirtualSubcontext)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        return !(this.nameInContext != null ? !this.nameInContext.equals(that.nameInContext) : that.nameInContext != null);
    }

    public int hashCode() {
        int result = this.nameInContext != null ? this.nameInContext.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    public void close() throws NamingException {
        this.context.close();
    }

    public String getNameInNamespace() throws NamingException {
        Name parsedNameInNamespace = this.context.getNameParser("").parse(this.context.getNameInNamespace());
        return this.context.composeName(parsedNameInNamespace, this.nameInContext).toString();
    }
}

