/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.AbstractFederatedContext;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.reference.CachingReference;

public class WritableContext
extends AbstractFederatedContext {
    private final Lock writeLock = new ReentrantLock();
    private final AtomicReference bindingsRef;
    private final AtomicReference indexRef;
    private final boolean cacheReferences;

    public WritableContext() throws NamingException {
        this("", Collections.EMPTY_MAP, ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace) throws NamingException {
        this(nameInNamespace, Collections.EMPTY_MAP, ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace, Map bindings) throws NamingException {
        this(nameInNamespace, bindings, ContextAccess.MODIFIABLE, false);
    }

    public WritableContext(String nameInNamespace, Map bindings, boolean cacheReferences) throws NamingException {
        this(nameInNamespace, bindings, ContextAccess.MODIFIABLE, cacheReferences);
    }

    public WritableContext(String nameInNamespace, Map bindings, ContextAccess contextAccess) throws NamingException {
        this(nameInNamespace, bindings, contextAccess, false);
    }

    public WritableContext(String nameInNamespace, Map bindings, ContextAccess contextAccess, boolean cacheReferences) throws NamingException {
        super(nameInNamespace, contextAccess);
        this.cacheReferences = cacheReferences;
        if (this.cacheReferences) {
            bindings = CachingReference.wrapReferences(bindings);
        }
        Map localBindings = ContextUtil.createBindings(bindings, this);
        this.bindingsRef = new AtomicReference(Collections.unmodifiableMap(localBindings));
        this.indexRef = new AtomicReference(Collections.unmodifiableMap(WritableContext.buildIndex("", localBindings)));
    }

    protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        if (super.addBinding(name, value, rebind)) {
            return true;
        }
        this.addBinding(this.bindingsRef, name, value, rebind);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBinding(AtomicReference bindingsRef, String name, Object value, boolean rebind) throws NamingException {
        this.writeLock.lock();
        try {
            Map bindings = (Map)bindingsRef.get();
            if (!rebind && bindings.containsKey(name)) {
                throw new NameAlreadyBoundException(name);
            }
            if (this.cacheReferences) {
                value = CachingReference.wrapReference(this.getNameInNamespace(name), value);
            }
            HashMap<String, Object> newBindings = new HashMap<String, Object>(bindings);
            newBindings.put(name, value);
            bindingsRef.set(newBindings);
            Map newIndex = this.addToIndex(name, value);
            this.indexRef.set((Object)newIndex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map addToIndex(String name, Object value) {
        Map index = (Map)this.indexRef.get();
        HashMap<String, Object> newIndex = new HashMap<String, Object>(index);
        newIndex.put(name, value);
        if (value instanceof NestedWritableContext) {
            NestedWritableContext nestedcontext = (NestedWritableContext)value;
            Map newIndexValues = WritableContext.buildIndex(name, (Map)nestedcontext.bindingsRef.get());
            newIndex.putAll(newIndexValues);
        }
        return newIndex;
    }

    protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
        if (super.removeBinding(name, removeNotEmptyContext)) {
            return true;
        }
        this.removeBinding(this.bindingsRef, name, removeNotEmptyContext);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBinding(AtomicReference bindingsRef, String name, boolean removeNotEmptyContext) throws NamingException {
        this.writeLock.lock();
        try {
            Map bindings = (Map)bindingsRef.get();
            if (!bindings.containsKey(name)) {
                boolean bl = false;
                return bl;
            }
            HashMap newBindings = new HashMap(bindings);
            Object oldValue = newBindings.remove(name);
            if (!removeNotEmptyContext && oldValue instanceof Context && !WritableContext.isEmpty((Context)oldValue)) {
                throw new ContextNotEmptyException(name);
            }
            bindingsRef.set(newBindings);
            Map newIndex = this.removeFromIndex(name);
            this.indexRef.set((Object)newIndex);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map removeFromIndex(String name) {
        Map index = (Map)this.indexRef.get();
        HashMap newIndex = new HashMap(index);
        Object oldValue = newIndex.remove(name);
        if (oldValue instanceof NestedWritableContext) {
            NestedWritableContext nestedcontext = (NestedWritableContext)oldValue;
            Map removedIndexValues = WritableContext.buildIndex(name, (Map)nestedcontext.bindingsRef.get());
            Iterator iterator = removedIndexValues.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                newIndex.remove(key);
            }
        }
        return newIndex;
    }

    public Context createNestedSubcontext(String path, Map bindings) throws NamingException {
        return new NestedWritableContext(path, bindings);
    }

    private static Map buildIndex(String nameInNamespace, Map bindings) {
        String path = nameInNamespace;
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        HashMap absoluteIndex = new HashMap();
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof NestedWritableContext) {
                NestedWritableContext nestedContext = (NestedWritableContext)value;
                absoluteIndex.putAll(WritableContext.buildIndex(nestedContext.pathWithSlash, (Map)nestedContext.bindingsRef.get()));
            }
            absoluteIndex.put(path + name, value);
        }
        return absoluteIndex;
    }

    protected Object getDeepBinding(String name) {
        Map index = (Map)this.indexRef.get();
        return index.get(name);
    }

    protected Map getWrapperBindings() throws NamingException {
        Map bindings = (Map)this.bindingsRef.get();
        return bindings;
    }

    public class NestedWritableContext
    extends AbstractFederatedContext {
        private final AtomicReference bindingsRef;
        private final String pathWithSlash;

        public NestedWritableContext(String path, Map bindings) throws NamingException {
            super(WritableContext.this, path);
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.pathWithSlash = path;
            this.bindingsRef = new AtomicReference(Collections.unmodifiableMap(bindings));
        }

        public Context createNestedSubcontext(String path, Map bindings) throws NamingException {
            return new NestedWritableContext(path, bindings);
        }

        protected Object getDeepBinding(String name) {
            String absoluteName = this.pathWithSlash + name;
            return WritableContext.this.getDeepBinding(absoluteName);
        }

        protected Map getWrapperBindings() throws NamingException {
            Map bindings = (Map)this.bindingsRef.get();
            return bindings;
        }

        protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
            if (super.addBinding(name, value, rebind)) {
                return true;
            }
            WritableContext.this.addBinding(this.bindingsRef, name, value, rebind);
            return true;
        }

        protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
            if (WritableContext.this.removeBinding(this.bindingsRef, name, false)) {
                return true;
            }
            return super.removeBinding(name, false);
        }
    }
}

