/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFinder {
    private final Map<String, List<Info>> annotated = new HashMap<String, List<Info>>();
    protected final List<ClassInfo> classInfos = new ArrayList<ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private final int ASM_FLAGS = 7;

    protected abstract URL getResource(String var1);

    protected abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    public List<Class> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                Class clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class> findInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        boolean annClassFound;
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            try {
                if (!(info instanceof ClassInfo)) continue;
                classes.add(((ClassInfo)info).get());
            }
            catch (ClassNotFoundException cnfe) {}
        }
        ArrayList<ClassInfo> tempClassInfos = new ArrayList<ClassInfo>(this.classInfos);
        do {
            annClassFound = false;
            for (int pos = 0; pos < tempClassInfos.size(); ++pos) {
                ClassInfo classInfo = (ClassInfo)tempClassInfos.get(pos);
                try {
                    String superType = classInfo.getSuperType();
                    for (Class clazz : classes) {
                        if (!superType.equals(clazz.getName())) continue;
                        classes.add(classInfo.get());
                        tempClassInfos.remove(pos);
                        annClassFound = true;
                        break;
                    }
                    List<String> interfces = classInfo.getInterfaces();
                    block9: for (String interfce : interfces) {
                        for (Class clazz : classes) {
                            if (!interfce.replaceFirst("<.*>", "").equals(clazz.getName())) continue;
                            classes.add(classInfo.get());
                            tempClassInfos.remove(pos);
                            annClassFound = true;
                            continue block9;
                        }
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.classesNotLoaded.add(classInfo.getName());
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    this.classesNotLoaded.add(classInfo.getName());
                }
            }
        } while (annClassFound);
        return classes;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || !info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            FieldInfo fieldInfo;
            ClassInfo classInfo;
            if (!(info instanceof FieldInfo) || seen.contains(classInfo = (fieldInfo = (FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    public List<Class> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassInfo classInfo : this.classInfos) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    protected List<Info> getAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new ArrayList<Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    protected void readClassDef(InputStream in) throws IOException {
        ClassReader classReader = new ClassReader(in);
        classReader.accept((ClassVisitor)new InfoBuildingVisitor(), 7);
    }

    public static class GenericAwareInfoBuildingVisitor
    implements SignatureVisitor {
        private Info info;
        private TYPE type;
        private STATE state;
        private static boolean debug = false;

        public GenericAwareInfoBuildingVisitor() {
        }

        public GenericAwareInfoBuildingVisitor(TYPE type, Info info) {
            this.type = type;
            this.info = info;
            this.state = STATE.BEGIN;
        }

        public void visitFormalTypeParameter(String s) {
            if (debug) {
                System.out.println(" s=" + s);
            }
            switch (this.state) {
                case BEGIN: {
                    ((ClassInfo)this.info).name = ((ClassInfo)this.info).name + ("<" + s);
                }
            }
            this.state = STATE.FORMAL_TYPE_PARAM;
        }

        public SignatureVisitor visitClassBound() {
            if (debug) {
                System.out.println(" visitClassBound()");
            }
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            if (debug) {
                System.out.println(" visitInterfaceBound()");
            }
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            if (debug) {
                System.out.println(" visitSuperclass()");
            }
            this.state = STATE.SUPERCLASS;
            return this;
        }

        public SignatureVisitor visitInterface() {
            if (debug) {
                System.out.println(" visitInterface()");
            }
            ((ClassInfo)this.info).getInterfaces().add("");
            this.state = STATE.INTERFACE;
            return this;
        }

        public SignatureVisitor visitParameterType() {
            if (debug) {
                System.out.println(" visitParameterType()");
            }
            return this;
        }

        public SignatureVisitor visitReturnType() {
            if (debug) {
                System.out.println(" visitReturnType()");
            }
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            if (debug) {
                System.out.println(" visitExceptionType()");
            }
            return this;
        }

        public void visitBaseType(char c) {
            if (debug) {
                System.out.println(" visitBaseType(" + c + ")");
            }
        }

        public void visitTypeVariable(String s) {
            if (debug) {
                System.out.println(" visitTypeVariable(" + s + ")");
            }
        }

        public SignatureVisitor visitArrayType() {
            if (debug) {
                System.out.println(" visitArrayType()");
            }
            return this;
        }

        public void visitClassType(String s) {
            if (debug) {
                System.out.println(" visitClassType(" + s + ")");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce.length() == 0 ? this.javaName(s) : interfce + this.javaName(s);
                    interfces.set(idx, interfce);
                    break;
                }
                case SUPERCLASS: {
                    if (s.equals("java/lang/Object")) break;
                    ((ClassInfo)this.info).superType = this.javaName(s);
                }
            }
        }

        public void visitInnerClassType(String s) {
            if (debug) {
                System.out.println(" visitInnerClassType(" + s + ")");
            }
        }

        public void visitTypeArgument() {
            if (debug) {
                System.out.println(" visitTypeArgument()");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + "<";
                    interfces.set(idx, interfce);
                }
            }
        }

        public SignatureVisitor visitTypeArgument(char c) {
            if (debug) {
                System.out.println(" visitTypeArgument(" + c + ")");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + "<";
                    interfces.set(idx, interfce);
                }
            }
            return this;
        }

        public void visitEnd() {
            if (debug) {
                System.out.println(" visitEnd()");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + ">";
                    interfces.set(idx, interfce);
                    break;
                }
                case FORMAL_TYPE_PARAM: {
                    String name = ((ClassInfo)this.info).name;
                    if (!name.contains("<")) break;
                    ((ClassInfo)this.info).name = ((ClassInfo)this.info).name + ">";
                }
            }
            this.state = STATE.END;
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum STATE {
            BEGIN,
            END,
            SUPERCLASS,
            INTERFACE,
            FORMAL_TYPE_PARAM;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            CLASS;

        }
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private Info info;

        public InfoBuildingVisitor() {
        }

        public InfoBuildingVisitor(Info info) {
            this.info = info;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(this.javaName(name));
            } else {
                ClassInfo classInfo = new ClassInfo(this.javaName(name), this.javaName(superName));
                if (signature == null) {
                    for (String interfce : interfaces) {
                        classInfo.getInterfaces().add(this.javaName(interfce));
                    }
                } else {
                    new SignatureReader(signature).accept((SignatureVisitor)new GenericAwareInfoBuildingVisitor(GenericAwareInfoBuildingVisitor.TYPE.CLASS, classInfo));
                }
                this.info = classInfo;
                AbstractFinder.this.classInfos.add(classInfo);
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            AbstractFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return new InfoBuildingVisitor(annotationInfo);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassInfo classInfo = (ClassInfo)this.info;
            FieldInfo fieldInfo = new FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassInfo classInfo = (ClassInfo)this.info;
            MethodInfo methodInfo = new MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo);
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            MethodInfo methodInfo = (MethodInfo)this.info;
            List<AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationInfo
    extends Annotatable
    implements Info {
        private final String name;

        public AnnotationInfo(Annotation annotation) {
            this(annotation.getClass().getName());
        }

        public AnnotationInfo(Class<? extends Annotation> annotation) {
            this.name = annotation.getName().intern();
        }

        public AnnotationInfo(String name) {
            name = name.replaceAll("^L|;$", "");
            name = name.replace('/', '.');
            this.name = name.intern();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class FieldInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final String type;
        private final ClassInfo declaringClass;

        public FieldInfo(ClassInfo info, Field field) {
            super(field);
            this.declaringClass = info;
            this.name = field.getName();
            this.type = field.getType().getName();
        }

        public FieldInfo(ClassInfo declaringClass, String name, String type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.declaringClass + "#" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInfo
    extends Annotatable
    implements Info {
        private final ClassInfo declaringClass;
        private final String returnType;
        private final String name;
        private final List<List<AnnotationInfo>> parameterAnnotations;

        public MethodInfo(ClassInfo info, Constructor constructor) {
            super(constructor);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = "<init>";
            this.returnType = Void.TYPE.getName();
        }

        public MethodInfo(ClassInfo info, Method method) {
            super(method);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = method.getName();
            this.returnType = method.getReturnType().getName();
        }

        public MethodInfo(ClassInfo declarignClass, String name, String returnType) {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = declarignClass;
            this.name = name;
            this.returnType = returnType;
        }

        public List<List<AnnotationInfo>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public List<AnnotationInfo> getParameterAnnotations(int index) {
            if (index >= this.parameterAnnotations.size()) {
                for (int i = this.parameterAnnotations.size(); i <= index; ++i) {
                    ArrayList annotationInfos = new ArrayList();
                    this.parameterAnnotations.add(i, annotationInfos);
                }
            }
            return this.parameterAnnotations.get(index);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.declaringClass + "@" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassInfo
    extends Annotatable
    implements Info {
        private String name;
        private final List<MethodInfo> methods;
        private final List<MethodInfo> constructors;
        private String superType;
        private final List<String> interfaces;
        private final List<FieldInfo> fields;
        private Class<?> clazz;
        private ClassNotFoundException notFound;

        public ClassInfo(Class clazz) {
            super(clazz);
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.clazz = clazz;
            this.name = clazz.getName();
            Class superclass = clazz.getSuperclass();
            this.superType = superclass != null ? superclass.getName() : null;
        }

        public ClassInfo(String name, String superType) {
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.name = name;
            this.superType = superType;
        }

        public String getPackageName() {
            return this.name.substring(0, this.name.lastIndexOf("."));
        }

        public List<MethodInfo> getConstructors() {
            return this.constructors;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<MethodInfo> getMethods() {
            return this.methods;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getSuperType() {
            return this.superType;
        }

        public Class get() throws ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            if (this.notFound != null) {
                throw this.notFound;
            }
            try {
                String fixedName = this.name.replaceFirst("<.*>", "");
                this.clazz = AbstractFinder.this.loadClass(fixedName);
                return this.clazz;
            }
            catch (ClassNotFoundException notFound) {
                AbstractFinder.this.classesNotLoaded.add(this.name);
                this.notFound = notFound;
                throw notFound;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public class PackageInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name) {
            this.info = new ClassInfo(name, null);
            this.name = name;
            this.pkg = null;
        }

        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Info {
        public String getName();

        public List<AnnotationInfo> getAnnotations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Annotatable {
        private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

        public Annotatable(AnnotatedElement element) {
            for (Annotation annotation : element.getAnnotations()) {
                this.annotations.add(new AnnotationInfo(annotation.annotationType().getName()));
            }
        }

        public Annotatable() {
        }

        public List<AnnotationInfo> getAnnotations() {
            return this.annotations;
        }
    }
}

