/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.xbean.finder.filter.ClassFilter;
import org.apache.xbean.finder.filter.ContainsFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.FilterList;
import org.apache.xbean.finder.filter.PackageFilter;
import org.apache.xbean.finder.filter.PatternFilter;
import org.apache.xbean.finder.filter.PrefixFilter;
import org.apache.xbean.finder.filter.SuffixFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    private static final Filter NONE = new Filter(){

        public boolean accept(String name) {
            return false;
        }
    };

    public static Filter packages(String ... packages) {
        ArrayList<PackageFilter> filters = new ArrayList<PackageFilter>();
        for (String s : packages) {
            filters.add(new PackageFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter classes(String ... classes) {
        ArrayList<ClassFilter> filters = new ArrayList<ClassFilter>();
        for (String s : classes) {
            filters.add(new ClassFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter prefixes(String ... prefixes) {
        ArrayList<PrefixFilter> filters = new ArrayList<PrefixFilter>();
        for (String s : prefixes) {
            filters.add(new PrefixFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter tokens(String ... tokens) {
        ArrayList<ContainsFilter> filters = new ArrayList<ContainsFilter>();
        for (String s : tokens) {
            filters.add(new ContainsFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter suffixes(String ... suffixes) {
        ArrayList<SuffixFilter> filters = new ArrayList<SuffixFilter>();
        for (String s : suffixes) {
            filters.add(new SuffixFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter patterns(String ... patterns) {
        ArrayList<PatternFilter> filters = new ArrayList<PatternFilter>();
        for (String s : patterns) {
            filters.add(new PatternFilter(s));
        }
        return Filters.optimize(filters);
    }

    public static Filter optimize(Filter ... filters) {
        return Filters.optimize(Arrays.asList(filters));
    }

    public static Filter optimize(List<Filter> ... filterss) {
        LinkedHashSet<Filter> unwrapped = new LinkedHashSet<Filter>();
        for (List<Filter> filters : filterss) {
            Filters.unwrap(filters, unwrapped);
        }
        if (unwrapped.size() > 1) {
            Iterator iterator = unwrapped.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (filter != NONE) continue;
                iterator.remove();
            }
        }
        if (unwrapped.size() == 0) {
            return NONE;
        }
        if (unwrapped.size() == 1) {
            return (Filter)unwrapped.iterator().next();
        }
        return new FilterList(unwrapped);
    }

    public static Filter invert(Filter filter) {
        if (filter instanceof NegativeFilter) {
            NegativeFilter negativeFilter = (NegativeFilter)filter;
            return negativeFilter.getFilter();
        }
        return new NegativeFilter(filter);
    }

    private static void unwrap(List<Filter> filters, Set<Filter> unwrapped) {
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                FilterList filterList = (FilterList)filter;
                Filters.unwrap(filterList.getFilters(), unwrapped);
                continue;
            }
            unwrapped.add(filter);
        }
    }

    private static final class NegativeFilter
    implements Filter {
        private final Filter filter;

        public NegativeFilter(Filter filter) {
            this.filter = filter;
        }

        public boolean accept(String name) {
            return !this.filter.accept(name);
        }

        public Filter getFilter() {
            return this.filter;
        }
    }
}

