/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.generator;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.blueprint.generator.ElementMapping;
import org.apache.xbean.blueprint.generator.NamespaceMapping;
import org.apache.xbean.blueprint.generator.Type;

public final class Utils {
    public static final String XBEAN_ANNOTATION = "org.apache.xbean.XBean";
    public static final String PROPERTY_ANNOTATION = "org.apache.xbean.Property";
    public static final Map XSD_TYPES;

    private Utils() {
    }

    public static String decapitalise(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static boolean isSimpleType(Type type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isCollection()) {
            return false;
        }
        String name = type.getName();
        if (name.equals("java.lang.Class") || name.equals("javax.xml.namespace.QName")) {
            return true;
        }
        return Utils.hasPropertyEditor(name);
    }

    private static boolean hasPropertyEditor(String type) {
        try {
            Class theClass = Utils.loadClass(type);
            PropertyEditor editor = PropertyEditorManager.findEditor(theClass);
            return editor != null;
        }
        catch (Throwable e) {
            System.out.println("Warning, could not load class: " + type + ": " + e);
            return false;
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Utils.class.getClassLoader().loadClass(name);
    }

    public static String getXsdType(Type type) {
        String name = type.getName();
        String xsdType = (String)XSD_TYPES.get(name);
        if (xsdType == null) {
            xsdType = "xs:string";
        }
        return xsdType;
    }

    public static List findImplementationsOf(NamespaceMapping namespaceMapping, Type type) {
        ArrayList<ElementMapping> elements = new ArrayList<ElementMapping>();
        String nestedTypeName = type.getName();
        for (ElementMapping element : namespaceMapping.getElements()) {
            if (!element.getClassName().equals(nestedTypeName) && !element.getInterfaces().contains(nestedTypeName) && !element.getSuperClasses().contains(nestedTypeName)) continue;
            elements.add(element);
        }
        return elements;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(String.class.getName(), "xs:string");
        map.put(Boolean.class.getName(), "xs:boolean");
        map.put(Boolean.TYPE.getName(), "xs:boolean");
        map.put(Byte.class.getName(), "xs:byte");
        map.put(Byte.TYPE.getName(), "xs:byte");
        map.put(Short.class.getName(), "xs:short");
        map.put(Short.TYPE.getName(), "xs:short");
        map.put(Integer.class.getName(), "xs:integer");
        map.put(Integer.TYPE.getName(), "xs:integer");
        map.put(Long.class.getName(), "xs:long");
        map.put(Long.TYPE.getName(), "xs:long");
        map.put(Float.class.getName(), "xs:float");
        map.put(Float.TYPE.getName(), "xs:float");
        map.put(Double.class.getName(), "xs:double");
        map.put(Double.TYPE.getName(), "xs:double");
        map.put(java.util.Date.class.getName(), "xs:date");
        map.put(Date.class.getName(), "xs:date");
        map.put("javax.xml.namespace.QName", "xs:QName");
        XSD_TYPES = Collections.unmodifiableMap(map);
    }
}

