/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.generator;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.blueprint.generator.AttributeMapping;
import org.apache.xbean.blueprint.generator.ElementMapping;
import org.apache.xbean.blueprint.generator.InvalidModelException;
import org.apache.xbean.blueprint.generator.MapMapping;
import org.apache.xbean.blueprint.generator.MappingLoader;
import org.apache.xbean.blueprint.generator.NamespaceMapping;
import org.apache.xbean.blueprint.generator.ParameterMapping;
import org.apache.xbean.blueprint.generator.Type;
import org.apache.xbean.blueprint.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QdoxMappingLoader
implements MappingLoader {
    public static final String XBEAN_ANNOTATION = "org.apache.xbean.XBean";
    public static final String PROPERTY_ANNOTATION = "org.apache.xbean.Property";
    public static final String INIT_METHOD_ANNOTATION = "org.apache.xbean.InitMethod";
    public static final String DESTROY_METHOD_ANNOTATION = "org.apache.xbean.DestroyMethod";
    public static final String FACTORY_METHOD_ANNOTATION = "org.apache.xbean.FactoryMethod";
    public static final String MAP_ANNOTATION = "org.apache.xbean.Map";
    public static final String FLAT_PROPERTY_ANNOTATION = "org.apache.xbean.Flat";
    public static final String FLAT_COLLECTION_ANNOTATION = "org.apache.xbean.FlatCollection";
    public static final String ELEMENT_ANNOTATION = "org.apache.xbean.Element";
    private static final Log log = LogFactory.getLog(QdoxMappingLoader.class);
    private final String defaultNamespace;
    private final File[] srcDirs;
    private final String[] excludedClasses;
    private com.thoughtworks.qdox.model.Type collectionType;

    public QdoxMappingLoader(String defaultNamespace, File[] srcDirs, String[] excludedClasses) {
        this.defaultNamespace = defaultNamespace;
        this.srcDirs = srcDirs;
        this.excludedClasses = excludedClasses;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public File[] getSrcDirs() {
        return this.srcDirs;
    }

    @Override
    public Set<NamespaceMapping> loadNamespaces() throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        log.debug((Object)"Source directories: ");
        for (File sourceDirectory : this.srcDirs) {
            if (!sourceDirectory.isDirectory() && !sourceDirectory.toString().endsWith(".jar")) {
                log.warn((Object)("Specified source directory isn't a directory or a jar file: '" + sourceDirectory.getAbsolutePath() + "'."));
            }
            log.debug((Object)(" - " + sourceDirectory.getAbsolutePath()));
            QdoxMappingLoader.getSourceFiles(sourceDirectory, this.excludedClasses, builder);
        }
        this.collectionType = builder.getClassByName("java.util.Collection").asType();
        return this.loadNamespaces(builder);
    }

    private Set<NamespaceMapping> loadNamespaces(JavaDocBuilder builder) {
        List<ElementMapping> elements = this.loadElements(builder);
        HashMap<String, HashSet<ElementMapping>> elementsByNamespace = new HashMap<String, HashSet<ElementMapping>>();
        HashMap<String, ElementMapping> namespaceRoots = new HashMap<String, ElementMapping>();
        for (ElementMapping element : elements) {
            String namespace = element.getNamespace();
            HashSet<ElementMapping> namespaceElements = (HashSet<ElementMapping>)elementsByNamespace.get(namespace);
            if (namespaceElements == null) {
                namespaceElements = new HashSet<ElementMapping>();
                elementsByNamespace.put(namespace, namespaceElements);
            }
            namespaceElements.add(element);
            if (!element.isRootElement()) continue;
            if (namespaceRoots.containsKey(namespace)) {
                log.info((Object)("Multiple root elements found for namespace " + namespace));
            }
            namespaceRoots.put(namespace, element);
        }
        TreeSet<NamespaceMapping> namespaces = new TreeSet<NamespaceMapping>();
        for (Map.Entry entry : elementsByNamespace.entrySet()) {
            String namespace = (String)entry.getKey();
            Set namespaceElements = (Set)entry.getValue();
            ElementMapping rootElement = (ElementMapping)namespaceRoots.get(namespace);
            NamespaceMapping namespaceMapping = new NamespaceMapping(namespace, namespaceElements, rootElement);
            namespaces.add(namespaceMapping);
        }
        return Collections.unmodifiableSet(namespaces);
    }

    private List<ElementMapping> loadElements(JavaDocBuilder builder) {
        JavaSource[] javaSources = builder.getSources();
        ArrayList<ElementMapping> elements = new ArrayList<ElementMapping>();
        for (JavaSource javaSource : javaSources) {
            JavaClass[] classes;
            if (javaSource.getClasses().length == 0) {
                log.info((Object)("No Java Classes defined in: " + javaSource.getURL()));
                continue;
            }
            for (JavaClass javaClass : classes = javaSource.getClasses()) {
                ElementMapping element = this.loadElement(builder, javaClass);
                if (element != null && !javaClass.isAbstract()) {
                    elements.add(element);
                    continue;
                }
                log.debug((Object)("No XML annotation found for type: " + javaClass.getFullyQualifiedName()));
            }
        }
        return elements;
    }

    private ElementMapping loadElement(JavaDocBuilder builder, JavaClass javaClass) {
        JavaClass s;
        JavaMethod[] methods;
        DocletTag xbeanTag = javaClass.getTagByName(XBEAN_ANNOTATION);
        if (xbeanTag == null) {
            return null;
        }
        String element = this.getElementName(javaClass, xbeanTag);
        String description = QdoxMappingLoader.getProperty(xbeanTag, "description");
        if (description == null) {
            description = javaClass.getComment();
        }
        String namespace = QdoxMappingLoader.getProperty(xbeanTag, "namespace", this.defaultNamespace);
        boolean root = this.getBooleanProperty(xbeanTag, "rootElement");
        String contentProperty = QdoxMappingLoader.getProperty(xbeanTag, "contentProperty");
        String factoryClass = QdoxMappingLoader.getProperty(xbeanTag, "factoryClass");
        HashMap<String, MapMapping> mapsByPropertyName = new HashMap<String, MapMapping>();
        ArrayList<String> flatProperties = new ArrayList<String>();
        HashMap<String, String> flatCollections = new HashMap<String, String>();
        HashSet<AttributeMapping> attributes = new HashSet<AttributeMapping>();
        HashMap<String, AttributeMapping> attributesByPropertyName = new HashMap<String, AttributeMapping>();
        for (JavaClass jClass = javaClass; jClass != null; jClass = jClass.getSuperJavaClass()) {
            BeanProperty[] beanProperties;
            for (BeanProperty beanProperty : beanProperties = jClass.getBeanProperties()) {
                DocletTag flatPropTag;
                DocletTag flatColTag;
                JavaMethod acc;
                if (beanProperty.getMutator() == null) continue;
                AttributeMapping attributeMapping = this.loadAttribute(beanProperty, "");
                if (attributeMapping != null) {
                    attributes.add(attributeMapping);
                    attributesByPropertyName.put(attributeMapping.getPropertyName(), attributeMapping);
                }
                if ((acc = beanProperty.getAccessor()) == null) continue;
                DocletTag mapTag = acc.getTagByName(MAP_ANNOTATION);
                if (mapTag != null) {
                    MapMapping mm = new MapMapping(mapTag.getNamedParameter("entryName"), mapTag.getNamedParameter("keyName"), Boolean.valueOf(mapTag.getNamedParameter("flat")), mapTag.getNamedParameter("dups"), mapTag.getNamedParameter("defaultKey"));
                    mapsByPropertyName.put(beanProperty.getName(), mm);
                }
                if ((flatColTag = acc.getTagByName(FLAT_COLLECTION_ANNOTATION)) != null) {
                    String childName = flatColTag.getNamedParameter("childElement");
                    if (childName == null) {
                        throw new InvalidModelException("Flat collections must specify the childElement attribute.");
                    }
                    flatCollections.put(beanProperty.getName(), childName);
                }
                if ((flatPropTag = acc.getTagByName(FLAT_PROPERTY_ANNOTATION)) == null) continue;
                flatProperties.add(beanProperty.getName());
            }
        }
        String initMethod = null;
        String destroyMethod = null;
        String factoryMethod = null;
        for (JavaClass jClass = javaClass; jClass != null; jClass = jClass.getSuperJavaClass()) {
            JavaMethod[] methods2;
            for (JavaMethod method : methods2 = javaClass.getMethods()) {
                if (!method.isPublic() || method.isConstructor()) continue;
                if (initMethod == null && method.getTagByName(INIT_METHOD_ANNOTATION) != null) {
                    initMethod = method.getName();
                }
                if (destroyMethod == null && method.getTagByName(DESTROY_METHOD_ANNOTATION) != null) {
                    destroyMethod = method.getName();
                }
                if (factoryMethod != null || method.getTagByName(FACTORY_METHOD_ANNOTATION) == null) continue;
                factoryMethod = method.getName();
            }
        }
        ArrayList constructorArgs = new ArrayList();
        for (JavaMethod method : methods = javaClass.getMethods()) {
            JavaParameter[] parameters = method.getParameters();
            if (!this.isValidConstructor(factoryMethod, method, parameters)) continue;
            ArrayList<ParameterMapping> args = new ArrayList<ParameterMapping>(parameters.length);
            for (JavaParameter parameter : parameters) {
                AttributeMapping attributeMapping = (AttributeMapping)attributesByPropertyName.get(parameter.getName());
                if (attributeMapping == null) {
                    attributeMapping = this.loadParameter(parameter);
                    attributes.add(attributeMapping);
                    attributesByPropertyName.put(attributeMapping.getPropertyName(), attributeMapping);
                }
                args.add(new ParameterMapping(attributeMapping.getPropertyName(), this.toMappingType(parameter.getType(), null)));
            }
            constructorArgs.add(Collections.unmodifiableList(args));
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getFullyQualifiedNames(javaClass.getImplementedInterfaces()));
        JavaClass actualClass = javaClass;
        if (factoryClass != null) {
            JavaClass clazz = builder.getClassByName(factoryClass);
            if (clazz != null) {
                log.info((Object)("Detected factory: using " + factoryClass + " instead of " + javaClass.getFullyQualifiedName()));
                actualClass = clazz;
            } else {
                log.info((Object)("Could not load class built by factory: " + factoryClass));
            }
        }
        ArrayList<String> superClasses = new ArrayList<String>();
        JavaClass p = actualClass;
        if (actualClass != javaClass) {
            superClasses.add(actualClass.getFullyQualifiedName());
        }
        while ((s = p.getSuperJavaClass()) != null && !s.equals(p) && !"java.lang.Object".equals(s.getFullyQualifiedName())) {
            p = s;
            superClasses.add(p.getFullyQualifiedName());
            hashSet.addAll(this.getFullyQualifiedNames(p.getImplementedInterfaces()));
        }
        return new ElementMapping(namespace, element, javaClass.getFullyQualifiedName(), description, root, initMethod, destroyMethod, factoryMethod, contentProperty, attributes, constructorArgs, flatProperties, mapsByPropertyName, flatCollections, superClasses, hashSet);
    }

    private List<String> getFullyQualifiedNames(JavaClass[] implementedInterfaces) {
        ArrayList<String> l = new ArrayList<String>();
        for (JavaClass implementedInterface : implementedInterfaces) {
            l.add(implementedInterface.getFullyQualifiedName());
        }
        return l;
    }

    private String getElementName(JavaClass javaClass, DocletTag tag) {
        String elementName = QdoxMappingLoader.getProperty(tag, "element");
        if (elementName == null) {
            String className = javaClass.getFullyQualifiedName();
            int index = className.lastIndexOf(".");
            if (index > 0) {
                className = className.substring(index + 1);
            }
            if (className.endsWith("FactoryBean")) {
                className = className.substring(0, className.length() - 4);
            }
            elementName = Utils.decapitalise(className);
        }
        return elementName;
    }

    private AttributeMapping loadAttribute(BeanProperty beanProperty, String defaultDescription) {
        DocletTag propertyTag = QdoxMappingLoader.getPropertyTag(beanProperty);
        if (this.getBooleanProperty(propertyTag, "hidden")) {
            return null;
        }
        String attribute = QdoxMappingLoader.getProperty(propertyTag, "alias", beanProperty.getName());
        String attributeDescription = this.getAttributeDescription(beanProperty, propertyTag, defaultDescription);
        String defaultValue = QdoxMappingLoader.getProperty(propertyTag, "default");
        boolean fixed = this.getBooleanProperty(propertyTag, "fixed");
        boolean required = this.getBooleanProperty(propertyTag, "required");
        String nestedType = QdoxMappingLoader.getProperty(propertyTag, "nestedType");
        String propertyEditor = QdoxMappingLoader.getProperty(propertyTag, "propertyEditor");
        return new AttributeMapping(attribute, beanProperty.getName(), attributeDescription, this.toMappingType(beanProperty.getType(), nestedType), defaultValue, fixed, required, propertyEditor);
    }

    private static DocletTag getPropertyTag(BeanProperty beanProperty) {
        DocletTag propertyTag;
        DocletTag propertyTag2;
        JavaMethod accessor = beanProperty.getAccessor();
        if (accessor != null && (propertyTag2 = accessor.getTagByName(PROPERTY_ANNOTATION)) != null) {
            return propertyTag2;
        }
        JavaMethod mutator = beanProperty.getMutator();
        if (mutator != null && (propertyTag = mutator.getTagByName(PROPERTY_ANNOTATION)) != null) {
            return propertyTag;
        }
        return null;
    }

    private String getAttributeDescription(BeanProperty beanProperty, DocletTag propertyTag, String defaultDescription) {
        String description = QdoxMappingLoader.getProperty(propertyTag, "description");
        if (description != null && description.trim().length() > 0) {
            return description.trim();
        }
        JavaMethod accessor = beanProperty.getAccessor();
        if (accessor != null && (description = accessor.getComment()) != null && description.trim().length() > 0) {
            return description.trim();
        }
        JavaMethod mutator = beanProperty.getMutator();
        if (mutator != null && (description = mutator.getComment()) != null && description.trim().length() > 0) {
            return description.trim();
        }
        return defaultDescription;
    }

    private AttributeMapping loadParameter(JavaParameter parameter) {
        String parameterName = parameter.getName();
        String parameterDescription = this.getParameterDescription(parameter);
        JavaClass javaClass = parameter.getParentMethod().getParentClass();
        BeanProperty beanProperty = javaClass.getBeanProperty(parameterName);
        if (beanProperty != null) {
            AttributeMapping attributeMapping = this.loadAttribute(beanProperty, parameterDescription);
            if (attributeMapping == null) {
                throw new InvalidModelException("Hidden property usage: The construction method " + QdoxMappingLoader.toMethodLocator(parameter.getParentMethod()) + " can not use a hidded property " + parameterName);
            }
            return attributeMapping;
        }
        return new AttributeMapping(parameterName, parameterName, parameterDescription, this.toMappingType(parameter.getType(), null), null, false, false, null);
    }

    private String getParameterDescription(JavaParameter parameter) {
        DocletTag[] tags;
        String parameterName = parameter.getName();
        for (DocletTag tag : tags = parameter.getParentMethod().getTagsByName("param")) {
            if (!tag.getParameters()[0].equals(parameterName)) continue;
            String parameterDescription = tag.getValue().trim();
            if (parameterDescription.startsWith(parameterName)) {
                parameterDescription = parameterDescription.substring(parameterName.length()).trim();
            }
            return parameterDescription;
        }
        return null;
    }

    private boolean isValidConstructor(String factoryMethod, JavaMethod method, JavaParameter[] parameters) {
        if (!method.isPublic() || parameters.length == 0) {
            return false;
        }
        if (factoryMethod == null) {
            return method.isConstructor();
        }
        return method.getName().equals(factoryMethod);
    }

    private static String getProperty(DocletTag propertyTag, String propertyName) {
        return QdoxMappingLoader.getProperty(propertyTag, propertyName, null);
    }

    private static String getProperty(DocletTag propertyTag, String propertyName, String defaultValue) {
        String value = null;
        if (propertyTag != null) {
            value = propertyTag.getNamedParameter(propertyName);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private boolean getBooleanProperty(DocletTag propertyTag, String propertyName) {
        return QdoxMappingLoader.toBoolean(QdoxMappingLoader.getProperty(propertyTag, propertyName));
    }

    private static boolean toBoolean(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    private Type toMappingType(com.thoughtworks.qdox.model.Type type, String nestedType) {
        try {
            if (type.isArray()) {
                return Type.newArrayType(type.getValue(), type.getDimensions());
            }
            if (type.isA(this.collectionType)) {
                if (nestedType == null) {
                    nestedType = "java.lang.Object";
                }
                return Type.newCollectionType(type.getValue(), Type.newSimpleType(nestedType));
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Could not load type mapping", t);
        }
        return Type.newSimpleType(type.getValue());
    }

    private static String toMethodLocator(JavaMethod method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getParentClass().getFullyQualifiedName());
        if (!method.isConstructor()) {
            buf.append(".").append(method.getName());
        }
        buf.append("(");
        JavaParameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JavaParameter parameter = parameters[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameter.getName());
        }
        buf.append(") : ").append(method.getLineNumber());
        return buf.toString();
    }

    private static void getSourceFiles(File base, String[] excludedClasses, JavaDocBuilder builder) throws IOException {
        if (base.isDirectory()) {
            QdoxMappingLoader.listAllFileNames(base, "", excludedClasses, builder);
        } else {
            QdoxMappingLoader.listAllJarEntries(base, excludedClasses, builder);
        }
    }

    private static void listAllFileNames(File base, String prefix, String[] excludedClasses, JavaDocBuilder builder) throws IOException {
        File[] hits;
        if (!base.canRead() || !base.isDirectory()) {
            throw new IllegalArgumentException(base.getAbsolutePath());
        }
        for (File hit : hits = base.listFiles()) {
            String name;
            String string = name = prefix.equals("") ? hit.getName() : prefix + "/" + hit.getName();
            if (!hit.canRead() || QdoxMappingLoader.isExcluded(name, excludedClasses)) continue;
            if (hit.isDirectory()) {
                QdoxMappingLoader.listAllFileNames(hit, name, excludedClasses, builder);
                continue;
            }
            if (!name.endsWith(".java")) continue;
            builder.addSource(hit);
        }
    }

    private static void listAllJarEntries(File base, String[] excludedClasses, JavaDocBuilder builder) throws IOException {
        JarFile jarFile = new JarFile(base);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".java") || QdoxMappingLoader.isExcluded(name, excludedClasses) || name.endsWith("/package-info.java")) continue;
            builder.addSource(new URL("jar:" + base.toURI().toURL().toString() + "!/" + name));
        }
    }

    private static boolean isExcluded(String sourceName, String[] excludedClasses) {
        if (excludedClasses == null) {
            return false;
        }
        String className = sourceName;
        if (sourceName.endsWith(".java")) {
            className = className.substring(0, className.length() - ".java".length());
        }
        className = className.replace('/', '.');
        for (String excludedClass : excludedClasses) {
            if (!className.equals(excludedClass)) continue;
            return true;
        }
        return false;
    }
}

