/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ServiceProcessor;
import org.apache.aries.blueprint.compendium.cm.BaseManagedServiceFactory;
import org.apache.aries.blueprint.compendium.cm.CmManagedProperties;
import org.apache.aries.blueprint.compendium.cm.CmProperties;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.blueprint.utils.ServiceListener;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmManagedServiceFactory
extends BaseManagedServiceFactory<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmManagedServiceFactory.class);
    private ExtendedBlueprintContainer blueprintContainer;
    private String id;
    private String factoryPid;
    private List<String> interfaces;
    private int autoExport;
    private int ranking;
    private Map<Object, Object> serviceProperties;
    private String managedComponentName;
    private String componentDestroyMethod;
    private List<ServiceListener> listeners;
    private ServiceRegistration registration;

    public CmManagedServiceFactory(ExtendedBlueprintContainer blueprintContainer) {
        super(blueprintContainer.getBundleContext(), null);
        this.blueprintContainer = blueprintContainer;
    }

    public void init() throws Exception {
        LOGGER.debug("Initializing CmManagedServiceFactory for factoryPid={}", (Object)this.factoryPid);
        Properties props = new Properties();
        props.put("service.pid", this.factoryPid);
        Bundle bundle = this.blueprintContainer.getBundleContext().getBundle();
        props.put("Bundle-SymbolicName", bundle.getSymbolicName());
        props.put("Bundle-Version", bundle.getHeaders().get("Bundle-Version"));
        this.registration = this.blueprintContainer.getBundleContext().registerService(ManagedServiceFactory.class.getName(), (Object)this, (Dictionary)props);
    }

    @Override
    public void destroy() {
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.registration);
        super.destroy();
    }

    public Map<ServiceRegistration, Object> getServiceMap() {
        return Collections.unmodifiableMap(this.getServices());
    }

    public void setListeners(List<ServiceListener> listeners) {
        this.listeners = listeners;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFactoryPid(String factoryPid) {
        this.factoryPid = factoryPid;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setAutoExport(int autoExport) {
        this.autoExport = autoExport;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public void setServiceProperties(Map serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void setManagedComponentName(String managedComponentName) {
        this.managedComponentName = managedComponentName;
    }

    public void setComponentDestroyMethod(String componentDestroyMethod) {
        this.componentDestroyMethod = componentDestroyMethod;
    }

    private void getRegistrationProperties(Dictionary properties, boolean update) {
        String pid = (String)properties.get("service.pid");
        CmProperties cm = this.findServiceProcessor();
        if (cm == null) {
            while (!properties.isEmpty()) {
                properties.remove(properties.keys().nextElement());
            }
        } else if (!cm.getUpdate()) {
            if (update) {
                while (!properties.isEmpty()) {
                    properties.remove(properties.keys().nextElement());
                }
                for (Map.Entry<Object, Object> entry : cm.getProperties().entrySet()) {
                    properties.put(entry.getKey(), entry.getValue());
                }
            } else {
                cm.updated(properties);
            }
        }
        if (this.serviceProperties != null) {
            for (Map.Entry<Object, Object> entry : this.serviceProperties.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        properties.put("service.ranking", this.ranking);
        properties.put("service.pid", pid);
    }

    private void updateComponentProperties(Dictionary props) {
        CmManagedProperties cm = this.findBeanProcessor();
        if (cm != null) {
            cm.updated(props);
        }
    }

    private CmManagedProperties findBeanProcessor() {
        for (BeanProcessor beanProcessor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            CmManagedProperties cm;
            if (!(beanProcessor instanceof CmManagedProperties) || !this.managedComponentName.equals((cm = (CmManagedProperties)beanProcessor).getBeanName()) || !"".equals(cm.getPersistentId())) continue;
            return cm;
        }
        return null;
    }

    private CmProperties findServiceProcessor() {
        for (ServiceProcessor processor : this.blueprintContainer.getProcessors(ServiceProcessor.class)) {
            CmProperties cm;
            if (!(processor instanceof CmProperties) || !this.id.equals((cm = (CmProperties)processor).getServiceId())) continue;
            return cm;
        }
        return null;
    }

    private Method findDestroyMethod(Class clazz) {
        List methods;
        Method method = null;
        if (this.componentDestroyMethod != null && this.componentDestroyMethod.length() > 0 && (methods = ReflectionUtils.findCompatibleMethods((Class)clazz, (String)this.componentDestroyMethod, (Class[])new Class[]{Integer.TYPE})) != null && !methods.isEmpty()) {
            method = (Method)methods.get(0);
        }
        return method;
    }

    @Override
    protected Object doCreate(Dictionary properties) throws Exception {
        this.updateComponentProperties(this.copy(properties));
        Object component = this.blueprintContainer.getComponentInstance(this.managedComponentName);
        this.getRegistrationProperties(properties, false);
        return component;
    }

    @Override
    protected Object doUpdate(Object service, Dictionary properties) throws Exception {
        this.updateComponentProperties(this.copy(properties));
        this.getRegistrationProperties(properties, true);
        return service;
    }

    @Override
    protected void doDestroy(Object service, Dictionary properties, int code) throws Exception {
        Method method = this.findDestroyMethod(service.getClass());
        if (method != null) {
            try {
                method.invoke(service, code);
            }
            catch (Exception e) {
                LOGGER.info("Error destroying component", (Throwable)e);
            }
        }
    }

    @Override
    protected void postRegister(Object service, Dictionary properties, ServiceRegistration registration) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Hashtable props = new Hashtable();
            JavaUtils.copy((Dictionary)properties, props);
            for (ServiceListener listener : this.listeners) {
                listener.register(service, props);
            }
        }
    }

    @Override
    protected void preUnregister(Object service, Dictionary properties, ServiceRegistration registration) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Hashtable props = new Hashtable();
            JavaUtils.copy((Dictionary)properties, props);
            for (ServiceListener listener : this.listeners) {
                listener.unregister(service, props);
            }
        }
    }

    @Override
    protected String[] getExposedClasses(Object service) {
        Set<String> classes;
        Class<?> serviceClass = service.getClass();
        switch (this.autoExport) {
            case 2: {
                classes = ReflectionUtils.getImplementedInterfaces(new HashSet(), serviceClass);
                break;
            }
            case 3: {
                classes = ReflectionUtils.getSuperClasses(new HashSet(), serviceClass);
                break;
            }
            case 4: {
                classes = ReflectionUtils.getSuperClasses(new HashSet(), serviceClass);
                classes = ReflectionUtils.getImplementedInterfaces(classes, serviceClass);
                break;
            }
            default: {
                classes = new HashSet<String>(this.interfaces);
            }
        }
        return classes.toArray(new String[classes.size()]);
    }

    private Hashtable copy(Dictionary source) {
        Hashtable ht = new Hashtable();
        JavaUtils.copy(ht, (Dictionary)source);
        return ht;
    }
}

