/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.maven;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.xbean.spring.generator.DocumentationGenerator;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.QdoxMappingLoader;
import org.apache.xbean.spring.generator.XmlMetadataGenerator;
import org.apache.xbean.spring.generator.XsdGenerator;

public class XBeanMojo
extends AbstractMojo
implements LogFacade {
    private MavenProject project;
    private String namespace;
    private File srcDir;
    private File outputDir;
    private File schema;
    private String propertyEditorPaths;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)" ======= XBeanMojo settings =======");
        this.getLog().debug((CharSequence)("namespace[" + this.namespace + "]"));
        this.getLog().debug((CharSequence)("srcDir[" + this.srcDir + "]"));
        this.getLog().debug((CharSequence)("schema[" + this.schema + "]"));
        this.getLog().debug((CharSequence)("outputDir[" + this.outputDir + "]"));
        this.getLog().debug((CharSequence)("propertyEditorPaths[" + this.propertyEditorPaths + "]"));
        if (this.schema == null) {
            this.schema = new File(this.outputDir, this.project.getArtifactId() + ".xsd");
        }
        if (this.propertyEditorPaths != null) {
            LinkedList<String> editorSearchPath = new LinkedList<String>(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
            StringTokenizer paths = new StringTokenizer(this.propertyEditorPaths, " ,");
            editorSearchPath.addAll(Collections.list(paths));
            PropertyEditorManager.setEditorSearchPath(editorSearchPath.toArray(new String[editorSearchPath.size()]));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            this.schema.getParentFile().mkdirs();
            QdoxMappingLoader mappingLoader = new QdoxMappingLoader(this.namespace, new File[]{this.srcDir});
            GeneratorPlugin[] plugins = new GeneratorPlugin[]{new XmlMetadataGenerator((LogFacade)this, this.outputDir.getAbsolutePath()), new DocumentationGenerator((LogFacade)this, this.schema), new XsdGenerator((LogFacade)this, this.schema)};
            Set namespaces = mappingLoader.loadNamespaces();
            if (namespaces.isEmpty()) {
                System.out.println("Warning: no namespaces found!");
            }
            Iterator iterator = namespaces.iterator();
            while (iterator.hasNext()) {
                NamespaceMapping namespaceMapping = (NamespaceMapping)iterator.next();
                for (int i = 0; i < plugins.length; ++i) {
                    GeneratorPlugin plugin = plugins[i];
                    plugin.generate(namespaceMapping);
                }
            }
            Resource res = new Resource();
            res.setDirectory(this.outputDir.toString());
            this.project.addResource(res);
            this.log("...done.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void log(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void log(String message, int level) {
        this.getLog().info((CharSequence)message);
    }
}

