/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.str.BSPEnforcer;
import org.apache.ws.security.str.STRParser;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTokenRefSTRParser
implements STRParser {
    public static final String SIGNATURE_METHOD = "signature_method";
    private byte[] secretKey;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        WSSecurityEngineResult result;
        boolean bspCompliant = true;
        WSSConfig config = data.getWssConfig();
        if (config != null) {
            bspCompliant = config.isWsiBSPCompliant();
        }
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, bspCompliant);
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
        }
        if ((result = wsDocInfo.getResult(uri)) != null) {
            this.processPreviousResult(result, secRef, data, parameters, wsDocInfo, bspCompliant);
            if (this.secretKey == null) {
                throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsReference()) {
            Element token;
            QName el;
            Reference reference = secRef.getReference();
            this.secretKey = this.getSecretKeyFromToken(uri, reference.getValueType(), data);
            if (this.secretKey == null && (el = new QName((token = secRef.getTokenElement(strElement.getOwnerDocument(), wsDocInfo, data.getCallbackHandler())).getNamespaceURI(), token.getLocalName())).equals(WSSecurityEngine.BINARY_TOKEN)) {
                Processor proc = data.getWssConfig().getProcessor(WSSecurityEngine.BINARY_TOKEN);
                List<WSSecurityEngineResult> bstResult = proc.handleToken(token, data, wsDocInfo);
                BinarySecurity bstToken = (BinarySecurity)bstResult.get(0).get("binary-security-token");
                if (bspCompliant) {
                    BSPEnforcer.checkBinarySecurityBSPCompliance(secRef, bstToken);
                }
                this.secretKey = (byte[])bstResult.get(0).get("secret");
            }
            if (this.secretKey == null) {
                throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsKeyIdentifier()) {
            String valueType = secRef.getKeyIdentifierValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                AssertionWrapper assertion = SAMLUtil.getAssertionFromKeyIdentifier(secRef, strElement, data, wsDocInfo);
                this.secretKey = this.getSecretKeyFromAssertion(assertion, secRef, data, wsDocInfo, bspCompliant);
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(valueType)) {
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), valueType, data);
                if (this.secretKey == null) {
                    byte[] keyBytes = secRef.getSKIBytes();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        BinarySecurity bstToken = (BinarySecurity)bstResult.get("binary-security-token");
                        byte[] tokenDigest = WSSecurityUtil.generateDigest(bstToken.getToken());
                        if (!Arrays.equals(tokenDigest, keyBytes)) continue;
                        this.secretKey = (byte[])bstResult.get("secret");
                        break;
                    }
                }
                if (this.secretKey == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
                }
            } else {
                if (bspCompliant && "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType)) {
                    BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
                }
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), secRef.getKeyIdentifierValueType(), data);
                if (this.secretKey == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId", new Object[]{uri});
                }
            }
        } else {
            throw new WSSecurityException(6, "noReference");
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    private byte[] getSecretKeyFromToken(String id, String type, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, 9, data);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            if (data.getCallbackHandler() != null) {
                data.getCallbackHandler().handle(callbacks);
                return pwcb.getKey();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
        }
        return null;
    }

    private byte[] getSecretKeyFromAssertion(AssertionWrapper assertion, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo, boolean bspCompliant) throws WSSecurityException {
        SAMLKeyInfo samlKi;
        if (bspCompliant) {
            BSPEnforcer.checkSamlTokenBSPCompliance(secRef, assertion);
        }
        if ((samlKi = SAMLUtil.getCredentialFromSubject(assertion, data, wsDocInfo, bspCompliant)) == null) {
            throw new WSSecurityException(6, "invalidSAMLToken", new Object[]{"No Secret Key"});
        }
        return samlKi.getSecret();
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, Map<String, Object> parameters, WSDocInfo wsDocInfo, boolean bspCompliant) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (4 == action) {
            if (bspCompliant) {
                BSPEnforcer.checkEncryptedKeyBSPCompliance(secRef);
            }
            this.secretKey = (byte[])result.get("secret");
        } else if (2048 == action) {
            DerivedKeyToken dkt = (DerivedKeyToken)result.get("derived-key-token");
            byte[] secret = (byte[])result.get("secret");
            String algorithm = (String)parameters.get(SIGNATURE_METHOD);
            this.secretKey = dkt.deriveKey(WSSecurityUtil.getKeyLength(algorithm), secret);
        } else if (8 == action || 16 == action) {
            AssertionWrapper assertion = (AssertionWrapper)result.get("saml-assertion");
            this.secretKey = this.getSecretKeyFromAssertion(assertion, secRef, data, wsDocInfo, bspCompliant);
        } else if (1024 == action || 4096 == action) {
            this.secretKey = (byte[])result.get("secret");
        }
    }
}

